/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;

public record PassiveHeatSource(ResourceLocation id, Block block, int heat) {
    public PassiveHeatSource(ResourceLocation id, Block block, int heat) {
        Powah.LOGGER.debug("HEAT SOURCE RECIPE INIT: " + String.valueOf(this));
        this.id = id;
        this.block = block;
        this.heat = heat;
    }

    @Nullable
    public Fluid fluid() {
        Block block = this.block;
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return liquidBlock.fluid;
        }
        return null;
    }

    public static Collection<PassiveHeatSource> getAll() {
        Powah.LOGGER.debug("HEAT SOURCE RECIPE ALL: [" + PowahAPI.HEAT_SOURCES.entrySet().stream().map(e -> String.valueOf(e.getKey()) + " -> " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "]");
        ArrayList<PassiveHeatSource> result = new ArrayList<PassiveHeatSource>();
        for (Map.Entry<ResourceLocation, Integer> entry : PowahAPI.HEAT_SOURCES.entrySet()) {
            ResourceLocation id = entry.getKey();
            int heat = entry.getValue();
            Block block = (Block)BuiltInRegistries.BLOCK.get(id);
            if (block == Blocks.AIR) continue;
            result.add(new PassiveHeatSource(id, block, heat));
        }
        return result;
    }
}

