/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;

public record FluidCoolant(ResourceLocation id, Fluid fluid, Set<BucketItem> buckets, int coldness) {
    public static Collection<FluidCoolant> getAll() {
        ArrayList<FluidCoolant> result = new ArrayList<FluidCoolant>();
        for (Map.Entry<ResourceLocation, Integer> entry : PowahAPI.COOLANT_FLUIDS.entrySet()) {
            ResourceLocation id = entry.getKey();
            Integer heat = entry.getValue();
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
            if (fluid == Fluids.EMPTY) continue;
            HashSet<BucketItem> buckets = new HashSet<BucketItem>();
            Item bucket = fluid.getBucket();
            if (bucket instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)bucket;
                if (bucketItem.content == fluid) {
                    buckets.add(bucketItem);
                }
            }
            result.add(new FluidCoolant(Powah.id("fluid_coolant/" + id.getNamespace() + "/" + id.getPath()), fluid, buckets, heat));
        }
        return result;
    }
}

