/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.thermo.ThermoTile;
import owmii.powah.client.ClientUtils;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ThermoContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.util.Util;

public class ThermoScreen
extends AbstractEnergyScreen<ThermoTile, ThermoContainer> {
    public ThermoScreen(ThermoContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.THERMO);
    }

    @Override
    protected void drawBackground(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        super.drawBackground(gui, partialTicks, mouseX, mouseY);
        Textures.THERMO_GAUGE.drawScalableH(gui, ((ThermoTile)this.te).getEnergy().subSized(), this.leftPos + 5, this.topPos + 5);
        Tank tank = ((ThermoTile)this.te).getTank();
        if (!tank.isEmpty() && (sprite = ClientUtils.getStillTexture(fluidStack = tank.getFluid())) != null) {
            int color = ClientUtils.getFluidColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.BLOCK_ATLAS);
            Draw.gaugeV(sprite, this.leftPos + 157, this.topPos + 5, 14, 65, tank.getCapacity(), tank.getFluidAmount());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        long percent = ((ThermoTile)this.te).getGeneration() > 0L ? 100L * ((ThermoTile)this.te).generating / ((ThermoTile)this.te).getGeneration() : 0L;
        gui.drawString(this.font, percent + "% (" + ((ThermoTile)this.te).generating + " FE/t)", this.leftPos + 34, this.topPos + 10, 0x555555, false);
    }

    protected void renderTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        super.renderTooltip(gui, mouseX, mouseY);
        if (Textures.FURNATOR_GAUGE.isMouseOver(this.leftPos + 5, this.topPos + 5, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            Energy energy = ((ThermoTile)this.te).getEnergy();
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.generates").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(((ThermoTile)this.te).getGeneration())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.max.extract").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).withStyle(ChatFormatting.DARK_GRAY)));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        Tank tank = ((ThermoTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list.add(Component.translatable((String)"info.lollipop.coolant").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)tank.getFluid().getDisplayName().plainCopy().withStyle(ChatFormatting.AQUA)));
                list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Util.formatTankContent(tank)));
                list.add(Component.translatable((String)"info.lollipop.temperature").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.temperature.c", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + PowahAPI.getCoolant(tank.getFluid().getFluid())}).withStyle(ChatFormatting.DARK_GRAY)));
            } else {
                list.add(Component.translatable((String)"info.lollipop.fluid").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.literal((String)"---").withStyle(ChatFormatting.DARK_GRAY)));
            }
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
    }
}

