/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.client.ClientUtils;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.network.Network;
import owmii.powah.network.packet.SwitchGenModePacket;
import owmii.powah.util.Util;

public class ReactorScreen
extends AbstractEnergyScreen<ReactorTile, ReactorContainer> {
    private IconButton modeButton = IconButton.EMPTY;

    public ReactorScreen(ReactorContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.REACTOR);
    }

    @Override
    protected void init() {
        super.init();
        this.modeButton = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos - 11, this.topPos + 10, Textures.REACTOR_GEN_MODE.get(((ReactorTile)this.te).isGenModeOn()), b -> {
            Network.toServer(new SwitchGenModePacket(((ReactorTile)this.te).getBlockPos()));
            ((ReactorTile)this.te).setGenModeOn(!((ReactorTile)this.te).isGenModeOn());
        }, (Screen)this).setTooltipSupplier(() -> List.of(Component.translatable((String)"info.powah.gen.mode").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)("info.lollipop." + (((ReactorTile)this.te).isGenModeOn() ? "on" : "off"))).withStyle(((ReactorTile)this.te).isGenModeOn() ? ChatFormatting.GREEN : ChatFormatting.RED)), Component.translatable((String)"info.powah.gen.mode.desc").withStyle(ChatFormatting.DARK_GRAY))));
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.modeButton.setTexture(Textures.REACTOR_GEN_MODE.get(((ReactorTile)this.te).isGenModeOn()));
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        Textures.REACTOR_GAUGE.drawScalableH(guiGraphics, ((ReactorTile)this.te).getEnergy().subSized(), this.leftPos + 5, this.topPos + 5);
        Textures.REACTOR_GAUGE_URN.drawScalableH(guiGraphics, ((ReactorTile)this.te).fuel.subSized(), this.leftPos + 103, this.topPos + 13);
        Textures.REACTOR_GAUGE_CARBON.drawScalableH(guiGraphics, ((ReactorTile)this.te).carbon.subSized(), this.leftPos + 51, this.topPos + 6);
        Textures.REACTOR_GAUGE_REDSTONE.drawScalableH(guiGraphics, ((ReactorTile)this.te).redstone.subSized(), this.leftPos + 51, this.topPos + 52);
        Textures.REACTOR_GAUGE_COOLANT.drawScalableH(guiGraphics, ((ReactorTile)this.te).solidCoolant.subSized(), this.leftPos + 140, this.topPos + 52);
        Textures.REACTOR_GAUGE_TEMP.drawScalableH(guiGraphics, ((ReactorTile)this.te).temp.subSized(), this.leftPos + 114, this.topPos + 28);
        Textures.REACTOR_GEN_MODE_BG.draw(guiGraphics, this.modeButton.getX() - 4, this.modeButton.getY() - 4);
        Tank tank = ((ReactorTile)this.te).getTank();
        if (!tank.isEmpty() && (sprite = ClientUtils.getStillTexture(fluidStack = tank.getFluid())) != null) {
            int color = ClientUtils.getFluidColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.BLOCK_ATLAS);
            Draw.gaugeV(sprite, this.leftPos + 157, this.topPos + 5, 14, 65, tank.getCapacity(), tank.getFluidAmount());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void renderTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        ArrayList<MutableComponent> list;
        super.renderTooltip(gui, mouseX, mouseY);
        if (Textures.REACTOR_GAUGE.isMouseOver(this.leftPos + 5, this.topPos + 5, mouseX, mouseY)) {
            list = new ArrayList<MutableComponent>();
            Energy energy = ((ReactorTile)this.te).getEnergy();
            list.add(Component.translatable((String)"info.powah.gen.mode").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)("info.lollipop." + (((ReactorTile)this.te).isGenModeOn() ? "on" : "off"))).withStyle(((ReactorTile)this.te).isGenModeOn() ? ChatFormatting.GREEN : ChatFormatting.RED)));
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.powah.generation.factor").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(((ReactorTile)this.te).getGeneration())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.generating").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat((long)((ReactorTile)this.te).calcProduction())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.max.extract").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).withStyle(ChatFormatting.DARK_GRAY)));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_TEMP.isMouseOver(this.leftPos + 114, this.topPos + 28, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + String.format("%.1f", ((ReactorTile)this.te).temp.getTicks()) + " C")));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_URN.isMouseOver(this.leftPos + 103, this.topPos + 13, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"item.powah.uraninite").withStyle(ChatFormatting.GREEN));
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.0f", ((ReactorTile)this.te).fuel.getTicks()), String.format("%.0f", ((ReactorTile)this.te).fuel.getMax())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.using").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.mb.pet.tick", (Object[])new Object[]{String.valueOf(ChatFormatting.GREEN) + String.format("%.4f", ((ReactorTile)this.te).calcConsumption())}).withStyle(ChatFormatting.DARK_GRAY)));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_CARBON.isMouseOver(this.leftPos + 51, this.topPos + 6, mouseX, mouseY)) {
            list = new ArrayList();
            boolean b = ((ReactorTile)this.te).carbon.isEmpty();
            list.add(Component.translatable((String)"info.powah.carbon").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.DARK_GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).carbon.getTicks()), String.format("%.1f", ((ReactorTile)this.te).carbon.getMax())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.empty());
            list.add(Component.translatable((String)"enchantment.minecraft.efficiency").withStyle(ChatFormatting.DARK_AQUA));
            list.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_RED) + (b ? "+0 C" : "+180 C"))));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_REDSTONE.isMouseOver(this.leftPos + 51, this.topPos + 52, mouseX, mouseY)) {
            list = new ArrayList();
            boolean b = ((ReactorTile)this.te).redstone.isEmpty();
            list.add(Component.translatable((String)"info.powah.redstone").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.DARK_GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).redstone.getTicks()), String.format("%.1f", ((ReactorTile)this.te).redstone.getMax())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.empty());
            list.add(Component.translatable((String)"info.powah.production").withStyle(ChatFormatting.DARK_AQUA));
            list.add(Component.translatable((String)"info.powah.fuel.consumption").withStyle(ChatFormatting.DARK_RED));
            list.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_RED) + (b ? "+0 C" : "+120 C"))));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_COOLANT.isMouseOver(this.leftPos + 140, this.topPos + 52, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"info.powah.solid.coolant").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.DARK_GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).solidCoolant.getTicks()), String.format("%.1f", ((ReactorTile)this.te).solidCoolant.getMax())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + ((ReactorTile)this.te).solidCoolantTemp + " C")));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        Tank tank = ((ReactorTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<MutableComponent> list2 = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list2.add(Component.translatable((String)"info.lollipop.coolant").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)tank.getFluid().getDisplayName().plainCopy().withStyle(ChatFormatting.AQUA)));
                list2.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Util.formatTankContent(tank)));
                list2.add(Component.translatable((String)"info.lollipop.temperature").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.temperature.c", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + PowahAPI.getCoolant(tank.getFluid().getFluid())}).withStyle(ChatFormatting.DARK_GRAY)));
            } else {
                list2.add(Component.translatable((String)"info.lollipop.fluid").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.literal((String)"---").withStyle(ChatFormatting.DARK_GRAY)));
            }
            gui.renderComponentTooltip(this.font, list2, mouseX, mouseY);
        }
    }
}

