/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.magmator.MagmatorTile;
import owmii.powah.client.ClientUtils;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.MagmatorContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.util.Ticker;
import owmii.powah.util.Util;

public class MagmatorScreen
extends AbstractEnergyScreen<MagmatorTile, MagmatorContainer> {
    private final Ticker heat = new Ticker(20.0);

    public MagmatorScreen(MagmatorContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.MAGMATOR);
        if (((MagmatorTile)this.te).isBurning()) {
            this.heat.setTicks(20.0);
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (((MagmatorTile)this.te).isBurning()) {
            this.heat.onward();
        } else {
            this.heat.back();
        }
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        Textures.FURNATOR_GAUGE.drawScalableH(guiGraphics, ((MagmatorTile)this.te).getEnergy().subSized(), this.leftPos + 5, this.topPos + 5);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.heat.subSized());
        Textures.MAGMATOR_BUFFER.draw(guiGraphics, this.leftPos + 83, this.topPos + 29);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tank tank = ((MagmatorTile)this.te).getTank();
        if (!tank.isEmpty() && (sprite = ClientUtils.getStillTexture(fluidStack = tank.getFluid())) != null) {
            int color = ClientUtils.getFluidColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.BLOCK_ATLAS);
            Draw.gaugeV(sprite, this.leftPos + 157, this.topPos + 5, 14, 65, tank.getCapacity(), tank.getFluidAmount());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void renderTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        super.renderTooltip(gui, mouseX, mouseY);
        if (Textures.FURNATOR_GAUGE.isMouseOver(this.leftPos + 5, this.topPos + 5, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            Energy energy = ((MagmatorTile)this.te).getEnergy();
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.generates").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(((MagmatorTile)this.te).getGeneration())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.max.extract").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).withStyle(ChatFormatting.DARK_GRAY)));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        Tank tank = ((MagmatorTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list.add(Component.translatable((String)"info.lollipop.fluid").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)tank.getFluid().getDisplayName().plainCopy().withStyle(ChatFormatting.GOLD)));
                list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Util.formatTankContent(tank)));
                list.add(Component.translatable((String)"info.lollipop.Gain").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.per.mb", (Object[])new Object[]{PowahAPI.getMagmaticFluidHeat(tank.getFluid().getFluid()), "100"}).withStyle(ChatFormatting.DARK_GRAY)));
            } else {
                list.add(Component.translatable((String)"info.lollipop.fluid").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.literal((String)"---").withStyle(ChatFormatting.DARK_GRAY)));
            }
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
    }
}

