/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import owmii.powah.Powah;
import owmii.powah.block.cable.CableTile;
import owmii.powah.client.model.AbstractModel;
import owmii.powah.client.render.tile.CableRenderer;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.util.EnergyUtil;

public class CableModel
extends AbstractModel<CableTile, CableRenderer> {
    private static final String NORTH = "north";
    private static final String NORTH_PLATE = "north_plate";
    private static final String SOUTH = "south";
    private static final String SOUTH_PLATE = "south_plate";
    private static final String WEST = "west";
    private static final String WEST_PLATE = "west_plate";
    private static final String EAST = "east";
    private static final String EAST_PLATE = "east_plate";
    private static final String DOWN = "down";
    private static final String DOWN_PLATE = "down_plate";
    private static final String UP = "up";
    private static final String UP_PLATE = "up_plate";
    private final ModelPart north;
    private final ModelPart northPlate;
    private final ModelPart south;
    private final ModelPart southPlate;
    private final ModelPart west;
    private final ModelPart westPlate;
    private final ModelPart east;
    private final ModelPart eastPlate;
    private final ModelPart down;
    private final ModelPart downPlate;
    private final ModelPart upPlate;
    private final ModelPart up;
    private static final Map<Transfer, ResourceLocation> TEXTURES = new HashMap<Transfer, ResourceLocation>();

    public CableModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.north = root.getChild(NORTH);
        this.northPlate = root.getChild(NORTH_PLATE);
        this.south = root.getChild(SOUTH);
        this.southPlate = root.getChild(SOUTH_PLATE);
        this.west = root.getChild(WEST);
        this.westPlate = root.getChild(WEST_PLATE);
        this.east = root.getChild(EAST);
        this.eastPlate = root.getChild(EAST_PLATE);
        this.down = root.getChild(DOWN);
        this.downPlate = root.getChild(DOWN_PLATE);
        this.up = root.getChild(UP);
        this.upPlate = root.getChild(UP_PLATE);
    }

    public static LayerDefinition createDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        PartPose pos = PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f);
        root.addOrReplaceChild(NORTH, CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, -1.5f, -7.75f, 3.0f, 3.0f, 6.0f), pos);
        root.addOrReplaceChild(NORTH_PLATE, CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -2.5f, -8.2f, 5.0f, 5.0f, 1.0f), pos);
        root.addOrReplaceChild(SOUTH, CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, 1.75f, 3.0f, 3.0f, 6.0f), pos);
        root.addOrReplaceChild(SOUTH_PLATE, CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -2.5f, 7.2f, 5.0f, 5.0f, 1.0f), pos);
        root.addOrReplaceChild(WEST, CubeListBuilder.create().texOffs(19, 0).addBox(-7.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), pos);
        root.addOrReplaceChild(WEST_PLATE, CubeListBuilder.create().texOffs(13, 20).addBox(-8.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f), pos);
        root.addOrReplaceChild(EAST, CubeListBuilder.create().texOffs(19, 7).addBox(1.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), pos);
        root.addOrReplaceChild(EAST_PLATE, CubeListBuilder.create().texOffs(13, 20).addBox(7.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f), pos);
        root.addOrReplaceChild(DOWN, CubeListBuilder.create().texOffs(38, 10).addBox(-1.5f, -7.75f, -1.5f, 3.0f, 6.0f, 3.0f), pos);
        root.addOrReplaceChild(DOWN_PLATE, CubeListBuilder.create().texOffs(26, 20).addBox(-2.5f, -8.2f, -2.5f, 5.0f, 1.0f, 5.0f), pos);
        root.addOrReplaceChild(UP, CubeListBuilder.create().texOffs(38, 0).addBox(-1.5f, 1.75f, -1.5f, 3.0f, 6.0f, 3.0f), pos);
        root.addOrReplaceChild(UP_PLATE, CubeListBuilder.create().texOffs(26, 20).addBox(-2.5f, 7.2f, -2.5f, 5.0f, 1.0f, 5.0f), pos);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @Override
    public void render(CableTile te, CableRenderer renderer, PoseStack matrix, MultiBufferSource rtb, int light, int ov) {
        VertexConsumer buffer;
        Transfer type;
        if (te.getLevel() == null) {
            return;
        }
        Direction[] flags = new Direction[6];
        for (Direction side : te.energySides) {
            BlockPos pos = te.getBlockPos().relative(side);
            BlockEntity tile = te.getLevel().getBlockEntity(pos);
            Transfer config = te.getSideConfig().getType(side);
            if (tile instanceof CableTile || !EnergyUtil.hasEnergy(te.getLevel(), pos, side.getOpposite()) || !config.canExtract && !config.canReceive) continue;
            flags[side.get3DDataValue()] = side;
        }
        if (flags[0] != null && !(type = te.getSideConfig().getType(flags[0])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.up.render(matrix, buffer, light, ov);
            this.upPlate.render(matrix, buffer, light, ov);
        }
        if (flags[1] != null && !(type = te.getSideConfig().getType(flags[1])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.down.render(matrix, buffer, light, ov);
            this.downPlate.render(matrix, buffer, light, ov);
        }
        if (flags[2] != null && !(type = te.getSideConfig().getType(flags[2])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.south.render(matrix, buffer, light, ov);
            this.southPlate.render(matrix, buffer, light, ov);
        }
        if (flags[3] != null && !(type = te.getSideConfig().getType(flags[3])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.north.render(matrix, buffer, light, ov);
            this.northPlate.render(matrix, buffer, light, ov);
        }
        if (flags[4] != null && !(type = te.getSideConfig().getType(flags[4])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.west.render(matrix, buffer, light, ov);
            this.westPlate.render(matrix, buffer, light, ov);
        }
        if (flags[5] != null && !(type = te.getSideConfig().getType(flags[5])).equals((Object)Transfer.NONE)) {
            buffer = rtb.getBuffer(this.renderType(TEXTURES.get((Object)type)));
            this.east.render(matrix, buffer, light, ov);
            this.eastPlate.render(matrix, buffer, light, ov);
        }
    }

    static {
        TEXTURES.put(Transfer.ALL, Powah.id("textures/model/tile/energy_cable_all.png"));
        TEXTURES.put(Transfer.RECEIVE, Powah.id("textures/model/tile/energy_cable_out.png"));
        TEXTURES.put(Transfer.EXTRACT, Powah.id("textures/model/tile/energy_cable_in.png"));
    }
}

