/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.thermo.ThermoBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.util.Util;

public class ThermoTile
extends AbstractEnergyProvider<ThermoBlock>
implements IInventoryHolder,
ITankHolder {
    public long generating;

    public ThermoTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.THERMO_GEN.get(), pos, state, variant);
        ((Tank)this.tank.setCapacity(Util.bucketAmount() * 4).setValidator(stack -> PowahAPI.getCoolant(stack.getFluid()) != 0)).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public ThermoTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.readSync(nbt, registries);
        this.generating = nbt.getLong("generating");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putLong("generating", this.generating);
        return super.writeSync(nbt, registries);
    }

    @Override
    protected int postTick(Level world) {
        FluidStack fluid;
        int fluidCooling;
        boolean flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        boolean i = false;
        if (!this.isRemote() && this.checkRedstone() && !this.tank.isEmpty() && (fluidCooling = PowahAPI.getCoolant((fluid = this.tank.getFluid()).getFluid())) != 0) {
            BlockPos heatPos = this.worldPosition.below();
            BlockState state = world.getBlockState(heatPos);
            Block block = state.getBlock();
            int heat = PowahAPI.getHeatSource(block);
            if (!this.energy.isFull() && heat != 0) {
                if (block instanceof LiquidBlock && !state.getFluidState().isSource()) {
                    int level = (Integer)state.getValue((Property)LiquidBlock.LEVEL);
                    heat = (int)((float)heat / ((float)level + 1.0f));
                }
                this.generating = (int)((double)heat * Math.max(1.0, (1.0 + (double)fluidCooling) / 2.0) * (double)this.getGeneration() / 1000.0);
                this.energy.produce(this.generating);
                if (world.getGameTime() % 40L == 0L) {
                    this.tank.drain(Util.millibucketAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        return flag || this.generating > 0L ? 5 : -1;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean keepFluid() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

