/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.Builder;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.recipe.ReactorFuel;
import owmii.powah.util.EnergyUtil;
import owmii.powah.util.Ticker;
import owmii.powah.util.Util;

public class ReactorTile
extends AbstractEnergyProvider<ReactorBlock>
implements IInventoryHolder,
ITankHolder {
    private final Builder builder = new Builder(this);
    public final Ticker fuel = new Ticker(1000.0);
    public final Ticker carbon = Ticker.empty();
    public final Ticker redstone = Ticker.empty();
    public final Ticker solidCoolant = Ticker.empty();
    public int solidCoolantTemp;
    public final Ticker temp = new Ticker(1000.0);
    private int redstoneTemp;
    private int carbonTemp;
    private int baseTemp;
    public final Ticker bright = new Ticker(20.0);
    private boolean running;
    private boolean genModeOn;
    private boolean generate = true;

    public ReactorTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.REACTOR.get(), pos, state, variant);
        ((Tank)this.tank.setCapacity(Util.bucketAmount()).setValidator(stack -> PowahAPI.getCoolant(stack.getFluid()) != 0)).setChange(() -> this.sync(10));
        this.inv.add(5);
    }

    public ReactorTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void loadServerOnly(CompoundTag nbt) {
        super.loadServerOnly(nbt);
        this.baseTemp = nbt.getInt("base_temp");
        this.carbonTemp = nbt.getInt("carbon_temp");
        this.redstoneTemp = nbt.getInt("redstone_temp");
    }

    @Override
    public CompoundTag saveServerOnly(CompoundTag nbt) {
        nbt.putInt("base_temp", this.baseTemp);
        nbt.putInt("carbon_temp", this.carbonTemp);
        nbt.putInt("redstone_temp", this.redstoneTemp);
        return super.saveServerOnly(nbt);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.readSync(nbt, registries);
        this.builder.read(nbt);
        this.fuel.read(nbt, "fuel");
        this.carbon.read(nbt, "carbon");
        this.redstone.read(nbt, "redstone");
        this.solidCoolant.read(nbt, "solid_coolant");
        this.solidCoolantTemp = nbt.getInt("solid_coolant_temp");
        this.running = nbt.getBoolean("running");
        this.genModeOn = nbt.getBoolean("gen_mode");
        this.generate = nbt.getBoolean("generate");
        this.temp.read(nbt, "temperature");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        this.builder.write(nbt);
        this.fuel.write(nbt, "fuel");
        this.carbon.write(nbt, "carbon");
        this.redstone.write(nbt, "redstone");
        this.solidCoolant.write(nbt, "solid_coolant");
        nbt.putInt("solid_coolant_temp", this.solidCoolantTemp);
        nbt.putBoolean("running", this.running);
        nbt.putBoolean("gen_mode", this.genModeOn);
        nbt.putBoolean("generate", this.generate);
        this.temp.write(nbt, "temperature");
        return super.writeSync(nbt, registries);
    }

    @Override
    protected int postTick(Level world) {
        if (this.isRemote() || !this.builder.isDone(world)) {
            return -1;
        }
        long extracted = this.chargeItems(1);
        boolean flag = false;
        boolean flag2 = false;
        if (this.checkRedstone() && this.generate) {
            boolean generating = !this.energy.isFull() && !this.fuel.isEmpty();
            boolean b0 = this.processFuel();
            boolean b1 = this.processCarbon(world, generating);
            boolean b2 = this.processRedstone(world, generating);
            boolean b3 = this.processTemperature(world, generating);
            if (b0 || b1 || b2 || b3) {
                flag = true;
            }
            if (generating) {
                this.fuel.back(this.calcConsumption());
                this.energy.produce((long)this.calcProduction());
                flag = true;
                flag2 = true;
            }
            if (flag && this.isContainerOpen) {
                this.sync(3);
            }
        }
        this.checkGenMode();
        for (Direction direction : Direction.values()) {
            if (!this.canExtractEnergy(direction)) continue;
            long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
            BlockPos pos = this.worldPosition.relative(direction, direction.getAxis().isHorizontal() ? 2 : (direction.equals((Object)Direction.UP) ? 4 : 1));
            long received = EnergyUtil.pushEnergy(world, pos, direction.getOpposite(), amount);
            extracted += this.extractEnergy((int)received, false, direction);
        }
        if (this.running != flag2) {
            this.running = flag2;
            this.sync(5);
        }
        return extracted > 0L ? 5 : -1;
    }

    @Override
    protected void clientTick(Level world) {
        if (this.running) {
            this.bright.onward();
        } else {
            this.bright.back();
        }
    }

    private void checkGenMode() {
        if (this.genModeOn) {
            if (this.energy.isFull()) {
                this.generate = false;
            } else if (this.energy.getPercent() <= 70L) {
                this.generate = true;
            }
        }
    }

    public double calcProduction() {
        double d = this.carbon.isEmpty() ? 1.2 : 1.0;
        double d1 = this.redstone.isEmpty() ? 1.4 : 1.0;
        return (1.0 - this.calc()) * (this.fuel.getTicks() / 1000.0) * (double)this.getGeneration() / d / d1;
    }

    public double calcConsumption() {
        if (this.running) {
            double d1 = 1.0 + (double)((Tier)this.variant).ordinal() * 0.25;
            return (1.0 + (double)((Tier)this.variant).ordinal() * 0.25) * this.calc();
        }
        return 0.0;
    }

    public double calc() {
        double d0 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return this.temp.getTicks() / 1000.0 * 0.98 / 2.0 * d0;
    }

    private boolean processTemperature(Level world, boolean generating) {
        ItemStack stack;
        boolean flag = false;
        if (this.solidCoolant.isEmpty() && !(stack = this.inv.getStackInSlot(4)).isEmpty()) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((ItemLike)stack.getItem());
            int size = (Integer)coolant.getLeft();
            int temp = (Integer)coolant.getRight();
            if (size > 0 && temp < 2) {
                this.solidCoolant.setAll(size);
                this.solidCoolantTemp = temp;
                stack.shrink(1);
                flag = true;
            }
        }
        if (!this.solidCoolant.isEmpty()) {
            if (!this.tank.isEmpty() && generating && this.ticks % 40 == 0) {
                this.solidCoolant.back();
                if (this.solidCoolant.isEmpty()) {
                    this.solidCoolant.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.solidCoolantTemp = 0;
        }
        double temp = Math.min((double)(this.baseTemp + this.carbonTemp + this.redstoneTemp), this.temp.getMax());
        if (!this.tank.isEmpty()) {
            int coldness = -PowahAPI.getCoolant(this.tank.getFluid().getFluid());
            int i = Math.abs(coldness + this.solidCoolantTemp) + 1;
            temp /= (double)i;
            this.sync(5);
        }
        if (this.temp.getTicks() < temp) {
            this.temp.onward();
            flag = true;
        }
        if (this.ticks % (this.tank.isEmpty() ? 5 : (this.solidCoolant.isEmpty() ? 3 : 1)) == 0 && this.temp.getTicks() > temp) {
            this.temp.back();
            flag = true;
        }
        return flag;
    }

    private boolean processRedstone(Level world, boolean generating) {
        boolean flag = false;
        if (this.redstone.isEmpty()) {
            ItemStack stack = this.inv.getStackInSlot(3);
            if (stack.is(Tags.Items.DUSTS_REDSTONE)) {
                this.redstone.setAll(18.0);
            } else if (stack.is(Tags.Items.STORAGE_BLOCKS_REDSTONE)) {
                this.redstone.setAll(162.0);
            }
            this.redstoneTemp = 120;
            stack.shrink(1);
            flag = true;
        }
        if (!this.redstone.isEmpty()) {
            if (generating && this.ticks % 40 == 0) {
                this.redstone.back();
                if (this.redstone.isEmpty()) {
                    this.redstone.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.redstoneTemp = 0;
        }
        return flag;
    }

    private boolean processCarbon(Level world, boolean generating) {
        int carbon;
        ItemStack stack;
        boolean flag = false;
        if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(2)).isEmpty() && (carbon = stack.getBurnTime(RecipeType.SMELTING)) > 0) {
            this.carbon.setAll(carbon);
            this.carbonTemp = 180;
            stack.shrink(1);
            flag = true;
        }
        if (!this.carbon.isEmpty()) {
            if (generating) {
                this.carbon.back();
                if (this.carbon.isEmpty()) {
                    this.carbon.setMax(0.0);
                }
            }
        } else {
            this.carbonTemp = 0;
        }
        return flag;
    }

    private boolean processFuel() {
        ReactorFuel fuel;
        boolean flag = false;
        ItemStack stack = this.inv.getStackInSlot(1);
        if (!stack.isEmpty() && (fuel = ReactorFuel.getFuel((ItemLike)stack.getItem())) != null && (this.fuel.isEmpty() || this.fuel.getTicks() + (double)fuel.fuelAmount() <= this.fuel.getMax())) {
            this.fuel.add(fuel.fuelAmount());
            this.baseTemp = fuel.temperature();
            stack.shrink(1);
            flag = true;
        }
        if (this.fuel.isEmpty()) {
            this.baseTemp = 0;
        }
        return flag;
    }

    @Override
    public void onPlaced(Level world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlaced(world, state, placer, stack);
        this.builder.shuffle();
    }

    public void demolish(Level world) {
        this.builder.demolish(world);
    }

    public boolean isBuilt() {
        return this.builder.built;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        if (slot == 1) {
            return ReactorFuel.getFuel((ItemLike)stack.getItem()) != null;
        }
        if (slot == 2) {
            return stack.getBurnTime(RecipeType.SMELTING) > 0 && !stack.hasCraftingRemainingItem();
        }
        if (slot == 3) {
            return stack.is(Tags.Items.DUSTS_REDSTONE) || stack.is(Tags.Items.STORAGE_BLOCKS_REDSTONE);
        }
        if (slot == 4) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((ItemLike)stack.getItem());
            return (Integer)coolant.getLeft() > 0 && (Integer)coolant.getRight() < 2;
        }
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public Tank getTank() {
        return this.tank;
    }

    @Override
    public boolean keepFluid() {
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isGenModeOn() {
        return this.genModeOn;
    }

    public void setGenModeOn(boolean genModeOn) {
        this.genModeOn = genModeOn;
        this.sync();
    }
}

