/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.tuple.Pair;

public class PowahAPI {
    public static final Map<ResourceLocation, Integer> MAGMATIC_FLUIDS = new HashMap<ResourceLocation, Integer>();
    public static final Map<ResourceLocation, Integer> COOLANT_FLUIDS = new HashMap<ResourceLocation, Integer>();
    public static final Map<ResourceLocation, Pair<Integer, Integer>> SOLID_COOLANTS = new HashMap<ResourceLocation, Pair<Integer, Integer>>();
    public static final Map<ResourceLocation, Integer> HEAT_SOURCES = new HashMap<ResourceLocation, Integer>();

    public static void registerMagmaticFluid(ResourceLocation fluid, int heat) {
        MAGMATIC_FLUIDS.put(fluid, heat);
    }

    public static int getMagmaticFluidHeat(Fluid fluid) {
        return MAGMATIC_FLUIDS.getOrDefault(BuiltInRegistries.FLUID.getKey((Object)fluid), 0);
    }

    public static void registerCoolant(ResourceLocation fluid, int cooling) {
        COOLANT_FLUIDS.put(fluid, cooling);
    }

    public static int getCoolant(Fluid fluid) {
        return COOLANT_FLUIDS.getOrDefault(BuiltInRegistries.FLUID.getKey((Object)fluid), 0);
    }

    public static void registerHeatSource(ResourceLocation block, int heat) {
        HEAT_SOURCES.put(block, heat);
    }

    public static int getHeatSource(Block block) {
        return HEAT_SOURCES.getOrDefault(BuiltInRegistries.BLOCK.getKey((Object)block), 0);
    }

    public static void registerSolidCoolant(ItemLike item, int size, int cooling) {
        SOLID_COOLANTS.put(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Pair<Integer, Integer>)Pair.of((Object)size, (Object)cooling));
    }

    public static Pair<Integer, Integer> getSolidCoolant(ItemLike item) {
        return SOLID_COOLANTS.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Pair<Integer, Integer>)Pair.of((Object)0, (Object)0));
    }
}

