/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah;

import java.util.Map;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Blcks;
import owmii.powah.block.Tiles;
import owmii.powah.compat.curios.CuriosCompat;
import owmii.powah.components.PowahComponents;
import owmii.powah.config.v2.PowahConfig;
import owmii.powah.data.PowahDataGenerator;
import owmii.powah.entity.Entities;
import owmii.powah.inventory.Containers;
import owmii.powah.item.CreativeTabs;
import owmii.powah.item.Itms;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IBlock;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.item.ItemBlock;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.network.Network;
import owmii.powah.recipe.ReactorFuel;
import owmii.powah.recipe.Recipes;
import owmii.powah.util.Wrench;

@Mod(value="powah")
public class Powah {
    public static final String MOD_ID = "powah";
    private static final ConfigHolder<PowahConfig> CONFIG = PowahConfig.register();
    public static final Logger LOGGER = LogManager.getLogger((String)"powah");

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static PowahConfig config() {
        return (PowahConfig)CONFIG.getConfig();
    }

    public Powah(IEventBus modEventBus) {
        Blcks.DR.register(modEventBus);
        Tiles.DR.register(modEventBus);
        this.setupBlockItems(modEventBus);
        Itms.DR.register(modEventBus);
        Containers.DR.register(modEventBus);
        Entities.DR.register(modEventBus);
        Recipes.DR_SERIALIZER.register(modEventBus);
        Recipes.DR_TYPE.register(modEventBus);
        CreativeTabs.DR.register(modEventBus);
        PowahComponents.DR.register(modEventBus);
        modEventBus.addListener(RegisterCapabilitiesEvent.class, this::registerTransfer);
        modEventBus.addListener(Network::register);
        modEventBus.addListener(this::registerDataTypeMaps);
        modEventBus.addListener(event -> {
            PowahAPI.registerSolidCoolant((ItemLike)Blocks.SNOW_BLOCK, 48, -3);
            PowahAPI.registerSolidCoolant((ItemLike)Items.SNOWBALL, 12, -3);
            PowahAPI.registerSolidCoolant((ItemLike)Blocks.ICE, 48, -5);
            PowahAPI.registerSolidCoolant((ItemLike)Blocks.PACKED_ICE, 192, -8);
            PowahAPI.registerSolidCoolant((ItemLike)Blocks.BLUE_ICE, 568, -17);
            PowahAPI.registerSolidCoolant((ItemLike)Blcks.DRY_ICE.get(), 712, -32);
        });
        modEventBus.addListener(PowahDataGenerator::gatherData);
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getUseBlock() == TriState.FALSE) {
                return;
            }
            if (Wrench.removeWithWrench(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
            }
        });
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.init();
        }
    }

    private void registerDataTypeMaps(RegisterDataMapTypesEvent event) {
        event.register(ReactorFuel.DATA_MAP_TYPE);
    }

    private void registerTransfer(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Tiles.REACTOR_PART.get(), (reactorPart, unused) -> {
            if (reactorPart.isExtractor()) {
                return reactorPart.getCoreEnergyStorage();
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Tiles.REACTOR_PART.get(), (reactorPart, unused) -> reactorPart.getCoreItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Tiles.REACTOR_PART.get(), (reactorPart, unused) -> reactorPart.getCoreFluidHandler());
        for (DeferredHolder entry : Tiles.DR.getEntries()) {
            BlockEntity be = ((BlockEntityType)entry.get()).create(BlockPos.ZERO, Blocks.AIR.defaultBlockState());
            if (be == null) {
                throw new IllegalStateException("Failed to create a dummy BE for " + String.valueOf(entry.getId()));
            }
            Powah.registerBlockEntityCapability(event, (BlockEntityType)entry.get(), be.getClass());
        }
        for (DeferredHolder entry : Itms.DR.getEntries()) {
            Object object = entry.get();
            if (!(object instanceof IEnergyContainingItem)) continue;
            IEnergyContainingItem eci = (IEnergyContainingItem)object;
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, unused) -> {
                IEnergyContainingItem.Info info = eci.getEnergyInfo();
                if (info == null) {
                    return null;
                }
                Energy.Item energyItem = new Energy.Item((ItemStack)stack, info);
                return energyItem.createItemCapability();
            }, new ItemLike[]{(ItemLike)entry.get()});
        }
    }

    private static void registerBlockEntityCapability(RegisterCapabilitiesEvent event, BlockEntityType<?> beType, Class<?> beClass) {
        if (AbstractEnergyStorage.class.isAssignableFrom(beClass)) {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, beType, (o, side) -> {
                AbstractEnergyStorage energyStorage = (AbstractEnergyStorage)o;
                return energyStorage.getExternalStorage((Direction)side);
            });
        }
        if (IInventoryHolder.class.isAssignableFrom(beClass)) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, beType, (o, direction) -> {
                Inventory inv = ((IInventoryHolder)o).getInventory();
                if (!inv.isBlank()) {
                    return inv;
                }
                return null;
            });
        }
        if (ITankHolder.class.isAssignableFrom(beClass)) {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, beType, (o, direction) -> ((ITankHolder)o).getTank());
        }
    }

    private void setupBlockItems(IEventBus modEventBus) {
        modEventBus.addListener(event -> {
            if (event.getRegistryKey() == Registries.ITEM) {
                for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
                    ItemBlock blockItem;
                    ResourceKey id = (ResourceKey)entry.getKey();
                    if (!id.location().getNamespace().equals(MOD_ID)) continue;
                    Block block = (Block)entry.getValue();
                    if (block instanceof IBlock) {
                        IBlock iBlock = (IBlock)block;
                        blockItem = iBlock.getBlockItem(new Item.Properties(), CreativeTabs.MAIN_KEY);
                    } else {
                        blockItem = new ItemBlock(block, new Item.Properties(), CreativeTabs.MAIN_KEY);
                    }
                    ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)block);
                    Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)name, (Object)((Object)blockItem));
                }
            }
        });
    }
}

