/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.Guis;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageShowCorpseInventory
implements Message<MessageShowCorpseInventory> {
    public static final CustomPacketPayload.Type<MessageShowCorpseInventory> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"show_corpse_inventory"));
    private UUID playerUUID;
    private UUID deathID;

    public MessageShowCorpseInventory() {
    }

    public MessageShowCorpseInventory(UUID playerUUID, UUID deathID) {
        this.playerUUID = playerUUID;
        this.deathID = deathID;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        Guis.openCorpseGUI(sender, this.playerUUID, this.deathID);
    }

    @Override
    public MessageShowCorpseInventory fromBytes(RegistryFriendlyByteBuf buf) {
        this.playerUUID = new UUID(buf.readLong(), buf.readLong());
        this.deathID = new UUID(buf.readLong(), buf.readLong());
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeLong(this.playerUUID.getMostSignificantBits());
        buf.writeLong(this.playerUUID.getLeastSignificantBits());
        buf.writeLong(this.deathID.getMostSignificantBits());
        buf.writeLong(this.deathID.getLeastSignificantBits());
    }

    @Override
    public CustomPacketPayload.Type<MessageShowCorpseInventory> type() {
        return TYPE;
    }
}

