/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageOpenHistory
implements Message<MessageOpenHistory> {
    public static final CustomPacketPayload.Type<MessageOpenHistory> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"open_history"));
    private List<Death> deaths;

    public MessageOpenHistory() {
    }

    public MessageOpenHistory(List<Death> deaths) {
        this.deaths = deaths;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClientSide(IPayloadContext context) {
        if (this.deaths.size() > 0) {
            Minecraft.getInstance().setScreen((Screen)new DeathHistoryScreen(this.deaths));
        } else {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.corpse.no_death_history"), true);
        }
    }

    @Override
    public MessageOpenHistory fromBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag compound = buf.readNbt();
        ListTag list = compound.getList("Deaths", 10);
        this.deaths = new ArrayList<Death>();
        for (int i = 0; i < list.size(); ++i) {
            this.deaths.add(Death.fromNBT((HolderLookup.Provider)buf.registryAccess(), list.getCompound(i)));
        }
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (Death d : this.deaths) {
            CompoundTag c = d.toNBT((HolderLookup.Provider)buf.registryAccess(), false);
            list.add((Object)c);
        }
        compound.put("Deaths", (Tag)list);
        buf.writeNbt((Tag)compound);
    }

    @Override
    public CustomPacketPayload.Type<MessageOpenHistory> type() {
        return TYPE;
    }
}

