/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.gui.DeathHistoryContainer;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class DeathHistoryScreen
extends ScreenBase<AbstractContainerMenu> {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"textures/gui/gui_death_history.png");
    private final CachedMap<Death, DummyPlayer> players = new CachedMap(10000L);
    private Button previous;
    private Button next;
    private List<Death> deaths;
    private int index;
    private int hSplit;
    private static boolean errorShown;

    public DeathHistoryScreen(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new DeathHistoryContainer(), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.death_history.corpse.title"));
        this.deaths = deaths;
        this.index = 0;
        this.imageWidth = 248;
        this.imageHeight = 166;
        this.hSplit = this.imageWidth / 2;
    }

    protected void init() {
        super.init();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.corpse.previous"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }).bounds(this.leftPos + padding, this.topPos + this.imageHeight - buttonHeight - padding, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.corpse.show_items"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + (this.imageWidth - buttonWidth) / 2, this.topPos + this.imageHeight - buttonHeight - padding, buttonWidth, buttonHeight).build());
        this.next = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.corpse.next"), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
        }).bounds(this.leftPos + this.imageWidth - buttonWidth - padding, this.topPos + this.imageHeight - buttonHeight - padding, buttonWidth, buttonHeight).build());
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (x >= (double)(this.leftPos + 7) && x <= (double)(this.leftPos + this.hSplit) && y >= (double)(this.topPos + 70)) {
            Objects.requireNonNull(this.font);
            if (y <= (double)(this.topPos + 100 + 9)) {
                BlockPos pos = this.getCurrentDeath().getBlockPos();
                MutableComponent teleport = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()})).withStyle(style -> style.applyFormat(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
                this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"chat.corpse.teleport_death_location", (Object[])new Object[]{teleport}));
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.minecraft.setScreen(null);
            }
        }
        return super.mouseClicked(x, y, clickType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        Death death = this.getCurrentDeath();
        MutableComponent title = Component.translatable((String)"gui.corpse.death_history.title").withStyle(ChatFormatting.BLACK);
        int titleWidth = this.font.width(title.getString());
        guiGraphics.drawString(this.font, title.getVisualOrderText(), (this.imageWidth - titleWidth) / 2, 7, 0, false);
        MutableComponent date = Component.literal((String)DeathHistoryScreen.getDate(death.getTimestamp()).getString()).withStyle(ChatFormatting.DARK_GRAY);
        int dateWidth = this.font.width((FormattedText)date);
        guiGraphics.drawString(this.font, date.getVisualOrderText(), (this.imageWidth - dateWidth) / 2, 20, 0, false);
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.corpse.death_history.name").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY), 40);
        this.drawRight(guiGraphics, Component.literal((String)death.getPlayerName()).withStyle(ChatFormatting.GRAY), 40);
        MutableComponent dimension = Component.translatable((String)"gui.corpse.death_history.dimension").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY);
        this.drawLeft(guiGraphics, dimension, 55);
        String dimensionName = death.getDimension().split(":")[1];
        boolean shortened = false;
        int dimWidth = this.font.width((FormattedText)dimension);
        while (dimWidth + this.font.width(dimensionName + (shortened ? "..." : "")) >= this.hSplit - 7) {
            dimensionName = dimensionName.substring(0, dimensionName.length() - 1);
            shortened = true;
        }
        this.drawRight(guiGraphics, Component.translatable((String)(dimensionName + (shortened ? "..." : ""))).withStyle(ChatFormatting.GRAY), 55);
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.corpse.death_history.location").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY), 70);
        this.drawRight(guiGraphics, Component.literal((String)(Math.round(death.getPosX()) + " X")).withStyle(ChatFormatting.GRAY), 70);
        this.drawRight(guiGraphics, Component.literal((String)(Math.round(death.getPosY()) + " Y")).withStyle(ChatFormatting.GRAY), 85);
        this.drawRight(guiGraphics, Component.literal((String)(Math.round(death.getPosZ()) + " Z")).withStyle(ChatFormatting.GRAY), 100);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DummyPlayer dummyPlayer = this.players.get(death, () -> new DummyPlayer(this.minecraft.level, new GameProfile(death.getPlayerUUID(), death.getPlayerName()), death.getEquipment(), death.getModel()));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)((int)((double)this.leftPos + (double)this.imageWidth * 0.75) - 25), (int)(this.topPos + this.imageHeight / 2 + 5), (int)((int)((double)this.leftPos + (double)this.imageWidth * 0.75) + 25), (int)(this.topPos + this.imageHeight / 2 + 55), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)dummyPlayer);
        if (mouseX >= this.leftPos + 7 && mouseX <= this.leftPos + this.hSplit && mouseY >= this.topPos + 70) {
            Objects.requireNonNull(this.font);
            if (mouseY <= this.topPos + 100 + 9) {
                guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"tooltip.corpse.teleport").getVisualOrderText()), mouseX - this.leftPos, mouseY - this.topPos);
                return;
            }
        }
        if (mouseX < this.leftPos + 7) return;
        if (mouseX > this.leftPos + this.hSplit) return;
        if (mouseY < this.topPos + 55) return;
        Objects.requireNonNull(this.font);
        if (mouseY > this.topPos + 55 + 9) return;
        guiGraphics.renderTooltip(this.font, (List)Lists.newArrayList((Object[])new FormattedCharSequence[]{Component.translatable((String)"gui.corpse.death_history.dimension").getVisualOrderText(), Component.literal((String)death.getDimension()).withStyle(ChatFormatting.GRAY).getVisualOrderText()}), mouseX - this.leftPos, mouseY - this.topPos);
    }

    public static Component getDate(long timestamp) {
        SimpleDateFormat dateFormat;
        try {
            dateFormat = new SimpleDateFormat(Component.translatable((String)"gui.corpse.death_history.date_format").getString());
        }
        catch (Exception e) {
            if (!errorShown) {
                Main.LOGGER.error("Failed to create date format. This indicates a broken translation: 'gui.corpse.death_history.date_format' translated to {}", (Object)Component.translatable((String)"gui.corpse.death_history.date_format").getString());
                errorShown = true;
            }
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return Component.literal((String)dateFormat.format(new Date(timestamp)));
    }

    protected void containerTick() {
        super.containerTick();
        this.previous.active = this.index > 0;
        this.next.active = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(GuiGraphics guiGraphics, MutableComponent text, int height) {
        guiGraphics.drawString(this.font, text.getVisualOrderText(), 7, height, 0, false);
    }

    public void drawRight(GuiGraphics guiGraphics, MutableComponent text, int height) {
        int strWidth = this.font.width((FormattedText)text);
        guiGraphics.drawString(this.font, text.getVisualOrderText(), this.hSplit - strWidth, height, 0, false);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

