/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.TransferItemsButton;
import de.maxhenkel.corpse.net.MessageSwitchInventoryPage;
import de.maxhenkel.corpse.net.MessageTransferItems;
import java.util.Collections;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorpseAdditionalScreen
extends ScreenBase<CorpseAdditionalContainer> {
    public static final ResourceLocation CORPSE_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"textures/gui/gui_corpse.png");
    private static final int PADDING = 7;
    private Inventory playerInventory;
    private CorpseEntity corpse;
    private Button previous;
    private Button next;
    private int page;

    public CorpseAdditionalScreen(CorpseEntity corpse, Inventory playerInventory, CorpseAdditionalContainer container, Component title) {
        super(CORPSE_GUI_TEXTURE, container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.corpse = corpse;
        this.page = 0;
        this.imageWidth = 176;
        this.imageHeight = 248;
    }

    protected void init() {
        super.init();
        int left = (this.width - this.imageWidth) / 2;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.corpse.previous"), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageSwitchInventoryPage(this.page), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).bounds(left + 7, this.topPos + 149 - buttonHeight, buttonWidth, buttonHeight).build());
        this.next = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.corpse.next"), button -> {
            ++this.page;
            if (this.page >= this.getPages()) {
                this.page = this.getPages() - 1;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageSwitchInventoryPage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).bounds(left + this.imageWidth - buttonWidth - 7, this.topPos + 149 - buttonHeight, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)new TransferItemsButton(left + this.imageWidth - 18 - 9, this.topPos + 5, button -> PacketDistributor.sendToServer((CustomPacketPayload)new MessageTransferItems(), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }

    protected void containerTick() {
        super.containerTick();
        this.previous.active = this.page > 0;
        this.next.active = this.page < this.getPages() - 1;
    }

    private int getPages() {
        int size = this.corpse.getDeath().getAdditionalItems().size();
        return Math.max(1, size / 54 + (size % 54 == 0 ? 0 : 1));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.corpse.getDisplayName(), this.leftPos + 7, this.topPos + 7, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventory.getDisplayName(), this.leftPos + 7, this.topPos + this.imageHeight - 96 + 2, 0x404040, false);
        MutableComponent pageName = Component.translatable((String)"gui.corpse.page", (Object[])new Object[]{this.page + 1, this.getPages()});
        int pageWidth = this.font.width((FormattedText)pageName);
        guiGraphics.drawString(this.font, (Component)pageName, this.leftPos + this.imageWidth / 2 - pageWidth / 2, this.topPos + this.imageHeight - 113, 0x404040, false);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (mouseX >= this.leftPos + this.imageWidth - 18 - 9 && mouseX < this.leftPos + this.imageWidth - 9 && mouseY >= this.topPos + 5 && mouseY < this.topPos + 5 + 10) {
            guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"button.corpse.transfer_items").getVisualOrderText()), mouseX - this.leftPos, mouseY - this.topPos);
        }
    }
}

