/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting.replacers;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public final class TippedArrowRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes(IStackHelper stackHelper) {
        String group = "jei.tipped.arrow";
        ItemStack arrowStack = new ItemStack((ItemLike)Items.ARROW);
        Ingredient arrowIngredient = Ingredient.of((ItemStack[])new ItemStack[]{arrowStack});
        Registry potionRegistry = RegistryUtil.getRegistry(Registries.POTION);
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        return potionRegistry.holders().map(potion -> {
            ItemStack input = PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion);
            ItemStack output = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)potion);
            output.setCount(8);
            Ingredient potionIngredient = ingredientHelper.createNbtIngredient(input, stackHelper);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{arrowIngredient, arrowIngredient, arrowIngredient, arrowIngredient, potionIngredient, arrowIngredient, arrowIngredient, arrowIngredient, arrowIngredient});
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("jei.tipped.arrow." + output.getDescriptionId()));
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
            ShapedRecipe recipe = new ShapedRecipe(group, CraftingBookCategory.MISC, pattern, output);
            return new RecipeHolder(id, (Recipe)recipe);
        }).toList();
    }

    private TippedArrowRecipeMaker() {
    }
}

