/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.IExtendableCraftingRecipeCategory;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.recipes.CraftingExtensionHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CraftingRecipeCategory
implements IExtendableCraftingRecipeCategory,
IRecipeCategory<RecipeHolder<CraftingRecipe>> {
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final CraftingExtensionHelper extendableHelper = new CraftingExtensionHelper();

    public CraftingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.CRAFTING_TABLE));
        this.localizedName = Component.translatable((String)"gui.jei.category.craftingTable");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    @Override
    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CraftingRecipe> recipeHolder, IFocusGroup focuses) {
        ICraftingCategoryExtension<CraftingRecipe> recipeExtension = this.extendableHelper.getRecipeExtension(recipeHolder);
        recipeExtension.setRecipe(recipeHolder, builder, this.craftingGridHelper, focuses);
    }

    @Override
    public void draw(RecipeHolder<CraftingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ICraftingCategoryExtension<CraftingRecipe> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        extension.drawInfo(recipeHolder, recipeWidth, recipeHeight, guiGraphics, mouseX, mouseY);
    }

    @Override
    public List<Component> getTooltipStrings(RecipeHolder<CraftingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ICraftingCategoryExtension<CraftingRecipe> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        return extension.getTooltipStrings(recipeHolder, mouseX, mouseY);
    }

    @Override
    public boolean handleInput(RecipeHolder<CraftingRecipe> recipeHolder, double mouseX, double mouseY, InputConstants.Key input) {
        ICraftingCategoryExtension<CraftingRecipe> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        return extension.handleInput(recipeHolder, mouseX, mouseY, input);
    }

    @Override
    public boolean isHandled(RecipeHolder<CraftingRecipe> recipeHolder) {
        return this.extendableHelper.getOptionalRecipeExtension(recipeHolder).isPresent();
    }

    @Override
    public <R extends CraftingRecipe> void addExtension(Class<? extends R> recipeClass, ICraftingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        this.extendableHelper.addRecipeExtension(recipeClass, extension);
    }

    @Override
    public ResourceLocation getRegistryName(RecipeHolder<CraftingRecipe> recipeHolder) {
        ErrorUtil.checkNotNull(recipeHolder, "recipeHolder");
        return this.extendableHelper.getOptionalRecipeExtension(recipeHolder).flatMap(extension -> extension.getRegistryName(recipeHolder)).orElseGet(() -> recipeHolder.id());
    }
}

