/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.lookups;

import com.google.common.base.Preconditions;
import java.util.List;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.recipes.lookups.FocusedRecipes;
import mezz.jei.gui.recipes.lookups.IFocusedRecipes;
import mezz.jei.gui.recipes.lookups.ILookupState;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientLookupState
implements ILookupState {
    private final IRecipeManager recipeManager;
    private final IFocusGroup focuses;
    private final @Unmodifiable List<IRecipeCategory<?>> recipeCategories;
    private int recipeCategoryIndex;
    private int recipeIndex;
    private int recipesPerPage;
    @Nullable
    private IFocusedRecipes<?> focusedRecipes;

    public static ILookupState createWithFocus(IRecipeManager recipeManager, IFocusGroup focuses) {
        List<IRecipeCategory<?>> recipeCategories = recipeManager.createRecipeCategoryLookup().limitFocus(focuses.getAllFocuses()).get().toList();
        return new IngredientLookupState(recipeManager, focuses, recipeCategories);
    }

    public static ILookupState createWithCategories(IRecipeManager recipeManager, IFocusFactory focusFactory, List<IRecipeCategory<?>> recipeCategories) {
        return new IngredientLookupState(recipeManager, focusFactory.getEmptyFocusGroup(), recipeCategories);
    }

    private IngredientLookupState(IRecipeManager recipeManager, IFocusGroup focuses, List<IRecipeCategory<?>> recipeCategories) {
        this.recipeManager = recipeManager;
        this.focuses = focuses;
        this.recipeCategories = List.copyOf(recipeCategories);
    }

    @Override
    public IFocusGroup getFocuses() {
        return this.focuses;
    }

    @Override
    public @Unmodifiable List<IRecipeCategory<?>> getRecipeCategories() {
        return this.recipeCategories;
    }

    public int getRecipeCategoryIndex() {
        return this.recipeCategoryIndex;
    }

    @Override
    public boolean moveToRecipeCategory(IRecipeCategory<?> recipeCategory) {
        int recipeCategoryIndex = this.recipeCategories.indexOf(recipeCategory);
        if (recipeCategoryIndex >= 0) {
            this.moveToRecipeCategoryIndex(recipeCategoryIndex);
            return true;
        }
        return false;
    }

    @Override
    public void moveToRecipeCategoryIndex(int recipeCategoryIndex) {
        Preconditions.checkArgument((recipeCategoryIndex >= 0 ? 1 : 0) != 0, (Object)"Recipe category index cannot be negative.");
        this.recipeCategoryIndex = recipeCategoryIndex;
        this.recipeIndex = 0;
        this.focusedRecipes = null;
    }

    @Override
    public void nextRecipeCategory() {
        int recipesTypesCount = this.getRecipeCategories().size();
        this.moveToRecipeCategoryIndex((this.getRecipeCategoryIndex() + 1) % recipesTypesCount);
    }

    @Override
    public void previousRecipeCategory() {
        int recipesTypesCount = this.getRecipeCategories().size();
        this.moveToRecipeCategoryIndex((recipesTypesCount + this.getRecipeCategoryIndex() - 1) % recipesTypesCount);
    }

    @Override
    public void nextPage() {
        int recipeCount = this.recipeCount();
        this.recipeIndex += this.recipesPerPage;
        if (this.recipeIndex >= recipeCount) {
            this.recipeIndex = 0;
        }
    }

    @Override
    public void previousPage() {
        this.recipeIndex -= this.recipesPerPage;
        if (this.recipeIndex < 0) {
            int pageCount = this.pageCount();
            this.recipeIndex = (pageCount - 1) * this.recipesPerPage;
        }
    }

    public int recipeCount() {
        return this.getFocusedRecipes().getRecipes().size();
    }

    @Override
    public int pageCount() {
        int recipeCount = this.recipeCount();
        if (recipeCount <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(recipeCount, this.recipesPerPage);
    }

    @Override
    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    @Override
    public int getRecipesPerPage() {
        return this.recipesPerPage;
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        this.recipesPerPage = recipesPerPage;
    }

    @Override
    public IFocusedRecipes<?> getFocusedRecipes() {
        if (this.focusedRecipes == null) {
            IRecipeCategory<?> recipeCategory = this.recipeCategories.get(this.recipeCategoryIndex);
            this.focusedRecipes = FocusedRecipes.create(this.focuses, this.recipeManager, recipeCategory);
        }
        return this.focusedRecipes;
    }
}

