/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.input.ClickableIngredientInternal;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.lookups.StaticFocusedRecipes;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends Screen
implements IRecipesGui,
IRecipeFocusSource,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int minRecipePadding = 4;
    private static final int navBarPadding = 2;
    private static final int titleInnerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private static final int minGuiWidth = 198;
    private final IRecipeTransferManager recipeTransferManager;
    private final IModIdHelper modIdHelper;
    private final IClientConfig clientConfig;
    private final IInternalKeyMappings keyBindings;
    private final IRecipeManager recipeManager;
    private final Textures textures;
    private final BookmarkList bookmarks;
    private final IGuiHelper guiHelper;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<IRecipeLayoutDrawable<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private Component title = CommonComponents.EMPTY;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final Map<IRecipeLayoutDrawable<?>, RecipeTransferButton> recipeTransferButtons;
    private final Map<IRecipeLayoutDrawable<?>, RecipeBookmarkButton> recipeBookmarkButtons;
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private ImmutableRect2i idealArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleStringArea = ImmutableRect2i.EMPTY;
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IIngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig, Textures textures, IInternalKeyMappings keyBindings, IFocusFactory focusFactory, BookmarkList bookmarks, IGuiHelper guiHelper) {
        super((Component)Component.literal((String)"Recipes"));
        this.recipeManager = recipeManager;
        this.textures = textures;
        this.bookmarks = bookmarks;
        this.guiHelper = guiHelper;
        this.recipeTransferButtons = new HashMap();
        this.recipeBookmarkButtons = new HashMap();
        this.recipeTransferManager = recipeTransferManager;
        this.ingredientManager = ingredientManager;
        this.modIdHelper = modIdHelper;
        this.clientConfig = clientConfig;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, focusFactory);
        this.recipeCatalysts = new RecipeCatalysts(textures, recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, textures, recipeManager, guiHelper);
        this.focusFactory = focusFactory;
        this.minecraft = Minecraft.getInstance();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory(), textures);
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory(), textures);
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage(), textures);
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage(), textures);
        this.background = textures.getRecipeGuiBackground();
    }

    private static void drawCenteredStringWithShadow(GuiGraphics guiGraphics, Font font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        guiGraphics.drawString(font, string, textArea.getX(), textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(GuiGraphics guiGraphics, Font font, Component text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (FormattedText)text);
        guiGraphics.drawString(font, text, textArea.getX(), textArea.getY(), -1);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        int xSize = 198;
        int ySize = this.clientConfig.isCenterSearchBarEnabled() ? this.height - 76 : this.height - 58;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.width - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = this.idealArea = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.font);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.setX(rightButtonX);
        this.nextRecipeCategory.setY(recipeClassButtonTop);
        this.previousRecipeCategory.setX(leftButtonX);
        this.previousRecipeCategory.setY(recipeClassButtonTop);
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.setX(rightButtonX);
        this.nextPage.setY(pageButtonTop);
        this.previousPage.setX(leftButtonX);
        this.previousPage.setY(pageButtonTop);
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.getWidth() + 14).cropRight(this.nextRecipeCategory.getWidth() + 14);
        this.addRenderableWidget((GuiEventListener)this.nextRecipeCategory);
        this.addRenderableWidget((GuiEventListener)this.previousRecipeCategory);
        this.addRenderableWidget((GuiEventListener)this.nextPage);
        this.addRenderableWidget((GuiEventListener)this.previousPage);
        this.init = true;
        this.updateLayout();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderTransparentBackground(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.background.draw(guiGraphics, this.area);
        RenderSystem.disableBlend();
        guiGraphics.fill(RenderType.gui(), this.previousRecipeCategory.getX() + this.previousRecipeCategory.getWidth(), this.previousRecipeCategory.getY(), this.nextRecipeCategory.getX(), this.nextRecipeCategory.getY() + this.nextRecipeCategory.getHeight(), 0x30000000);
        guiGraphics.fill(RenderType.gui(), this.previousPage.getX() + this.previousPage.getWidth(), this.previousPage.getY(), this.nextPage.getX(), this.nextPage.getY() + this.nextPage.getHeight(), 0x30000000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(guiGraphics, this.font, this.title, this.titleArea);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(guiGraphics, this.font, this.pageString, pageArea);
        this.nextRecipeCategory.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.nextPage.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousPage.render(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.drawLayouts(guiGraphics, mouseX, mouseY);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.recipeCatalysts.draw(guiGraphics, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.minecraft, guiGraphics, mouseX, mouseY, this.modIdHelper, partialTicks);
        for (RecipeTransferButton recipeTransferButton : this.recipeTransferButtons.values()) {
            recipeTransferButton.drawToolTip(guiGraphics, mouseX, mouseY);
        }
        for (RecipeBookmarkButton recipeBookmarkButton : this.recipeBookmarkButtons.values()) {
            recipeBookmarkButton.drawToolTip(guiGraphics, mouseX, mouseY);
        }
        RenderSystem.disableBlend();
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(guiGraphics, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(guiGraphics));
        hoveredRecipeCatalyst.ifPresent(h -> h.getDisplayedIngredient().ifPresent(i -> {
            List<Component> tooltip = h.getTooltip();
            tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, i);
            TooltipRenderer.drawHoveringText(guiGraphics, tooltip, mouseX, mouseY, i, this.ingredientManager);
        }));
        RenderSystem.enableDepthTest();
        if (this.titleStringArea.contains(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            MutableComponent showAllRecipesString = Component.translatable((String)"jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(guiGraphics, List.of(showAllRecipesString), mouseX, mouseY);
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            guiGraphics.fill(RenderType.gui(), this.idealArea.getX(), this.idealArea.getY(), this.idealArea.getX() + this.idealArea.getWidth(), this.idealArea.getY() + this.idealArea.getHeight(), 0x4400FF00);
            guiGraphics.fill(RenderType.gui(), this.area.getX(), this.area.getY(), this.area.getX() + this.area.getWidth(), this.area.getY() + this.area.getHeight(), 0x44990044);
            ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
            guiGraphics.fill(RenderType.gui(), recipeLayoutsArea.getX(), recipeLayoutsArea.getY(), recipeLayoutsArea.getX() + recipeLayoutsArea.getWidth(), recipeLayoutsArea.getY() + recipeLayoutsArea.getHeight(), 0x44228844);
        }
    }

    private void updateAreaToFitLayouts() {
        if (this.recipeLayouts.isEmpty()) {
            return;
        }
        int padding = 12;
        int width = 186;
        IRecipeLayoutDrawable<?> recipeLayout = this.recipeLayouts.getFirst();
        int recipeWidth = this.layoutWidthWithButtons(recipeLayout);
        width = Math.max(recipeWidth, width);
        int newWidth = width + 12;
        int newX = (this.width - newWidth) / 2;
        this.area = new ImmutableRect2i(newX, this.area.getY(), newWidth, this.area.getHeight());
    }

    private int layoutWidthWithButtons(IRecipeLayoutDrawable<?> recipeLayout) {
        RecipeBookmarkButton recipeBookmarkButton;
        Rect2i area = recipeLayout.getRectWithBorder();
        int width = area.getWidth();
        RecipeTransferButton recipeTransferButton = this.recipeTransferButtons.get(recipeLayout);
        if (recipeTransferButton != null && recipeTransferButton.visible) {
            Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
            int buttonRight = buttonArea.getWidth() + buttonArea.getX();
            width = Math.max(buttonRight - area.getX(), width);
        }
        if ((recipeBookmarkButton = this.recipeBookmarkButtons.get(recipeLayout)) != null && recipeBookmarkButton.visible) {
            Rect2i buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
            int buttonRight = buttonArea.getWidth() + buttonArea.getX();
            width = Math.max(buttonRight - area.getX(), width);
        }
        return width;
    }

    private Optional<IRecipeLayoutDrawable<?>> drawLayouts(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
        }
        Minecraft minecraft = Minecraft.getInstance();
        DeltaTracker deltaTracker = minecraft.getTimer();
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        for (RecipeTransferButton recipeTransferButton : this.recipeTransferButtons.values()) {
            recipeTransferButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        for (RecipeBookmarkButton recipeBookmarkButton : this.recipeBookmarkButtons.values()) {
            recipeBookmarkButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
        return Optional.ofNullable(hoveredLayout);
    }

    public void tick() {
        super.tick();
        Optional.ofNullable(this.minecraft).map(minecraft -> minecraft.player).ifPresent(localPlayer -> {
            AbstractContainerMenu container = this.getParentContainer().orElse(null);
            for (RecipeTransferButton button : this.recipeTransferButtons.values()) {
                button.update(this.recipeTransferManager, container, (Player)localPlayer);
            }
        });
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.minecraft != null && this.minecraft.screen == this) {
            if (this.area.contains(mouseX, mouseY)) {
                return true;
            }
            for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    private Stream<IClickableIngredientInternal<?>> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayouts.stream().map(recipeLayout -> RecipesGui.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipesGui.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipesGui.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            IngredientElement element = new IngredientElement(displayedIngredient);
            return new ClickableIngredientInternal(element, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, Rect2i area) {
        Rect2i layoutArea = recipeLayout.getRect();
        return new ImmutableRect2i(area.getX() + layoutArea.getX(), area.getY() + layoutArea.getY(), area.getWidth(), area.getHeight());
    }

    public boolean mouseScrolled(double scrollX, double scrollY, double scrollDeltaX, double scrollDeltaY) {
        double y;
        double x = MouseUtil.getX();
        if (this.isMouseOver(x, y = MouseUtil.getY())) {
            if (scrollDeltaY < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDeltaY > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.mouseScrolled(scrollX, scrollY, scrollDeltaX, scrollDeltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IUserInputHandler handler;
        double mouseY;
        double mouseX = input.getMouseX();
        if (this.isMouseOver(mouseX, mouseY = input.getMouseY())) {
            if (this.titleStringArea.contains(mouseX, mouseY)) {
                if (input.is(this.keyBindings.getLeftClick()) && this.logic.showAllRecipes()) {
                    return true;
                }
            } else {
                for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                    if (!this.handleRecipeLayoutInput(recipeLayout, input)) continue;
                    return true;
                }
            }
        }
        if ((handler = this.recipeGuiTabs.getInputHandler()).handleUserInput(this, input, this.keyBindings).isPresent()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (input.is(this.keyBindings.getCloseRecipeGui()) || input.is(minecraft.options.keyInventory)) {
            this.onClose();
            return true;
        }
        if (input.is(this.keyBindings.getRecipeBack())) {
            this.back();
            return true;
        }
        if (input.is(this.keyBindings.getNextCategory())) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousCategory())) {
            this.logic.previousRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getNextRecipePage())) {
            this.logic.nextPage();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousRecipePage())) {
            this.logic.previousPage();
            return true;
        }
        return false;
    }

    private <R> boolean handleRecipeLayoutInput(IRecipeLayoutDrawable<R> recipeLayout, UserInput input) {
        if (!recipeLayout.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return false;
        }
        Rect2i recipeArea = recipeLayout.getRect();
        double recipeMouseX = input.getMouseX() - (double)recipeArea.getX();
        double recipeMouseY = input.getMouseY() - (double)recipeArea.getY();
        R recipe = recipeLayout.getRecipe();
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
            return true;
        }
        if (input.is(this.keyBindings.getCopyRecipeId())) {
            return this.handleCopyRecipeId(recipeLayout);
        }
        return false;
    }

    private <R> boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
        R recipe;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        ResourceLocation registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
        if (registryName == null) {
            MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.failure");
            if (player != null) {
                player.displayClientMessage((Component)message, false);
            }
            return false;
        }
        String recipeId = registryName.toString();
        minecraft.keyboardHandler.setClipboard(recipeId);
        MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{Component.literal((String)recipeId)});
        if (player != null) {
            player.displayClientMessage((Component)message, false);
        }
        return true;
    }

    public boolean isOpen() {
        return this.minecraft != null && this.minecraft.screen == this;
    }

    private void open() {
        if (this.minecraft != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.minecraft.screen;
            }
            this.minecraft.setScreen((Screen)this);
        }
    }

    public void onClose() {
        if (this.isOpen() && this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.onClose();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.showFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.showCategories(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> void showRecipes(IRecipeCategory<T> recipeCategory, List<T> recipes, List<IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotEmpty(recipes, "recipes");
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        StaticFocusedRecipes<T> focusedRecipes = new StaticFocusedRecipes<T>(recipeCategory, recipes);
        if (this.logic.showRecipes(focusedRecipes, checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        ImmutableRect2i layoutRect;
        int recipeHeight;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        int availableHeight = this.getRecipeLayoutsArea().getHeight();
        int recipesPerPage = 1 + (availableHeight - (recipeHeight = (layoutRect = this.logic.getRecipeLayoutSizeWithBorder().orElseGet(() -> new ImmutableRect2i(0, 0, recipeCategory.getWidth(), recipeCategory.getHeight()))).getHeight())) / (recipeHeight + 4);
        if (recipesPerPage <= 0) {
            availableHeight = recipeHeight;
            recipesPerPage = 1;
        }
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.font.width((FormattedText)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.font);
        }
        this.titleStringArea = MathUtil.centerTextArea(this.titleArea, this.font, (FormattedText)this.title);
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts());
        this.addRecipeButtons(this.recipeLayouts);
        this.updateAreaToFitLayouts();
        ImmutableRect2i layoutsArea = this.getRecipeLayoutsArea();
        int recipeXOffset = this.getRecipeXOffset(layoutRect, layoutsArea);
        int recipeHeightTotal = recipesPerPage * layoutRect.getHeight();
        int remainingHeight = availableHeight - recipeHeightTotal;
        int recipeSpacing = remainingHeight / (recipesPerPage + 1);
        int spacingY = layoutRect.getHeight() + recipeSpacing;
        int recipeYOffset = layoutsArea.getY() + recipeSpacing;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
            Rect2i rectWithBorder = recipeLayout.getRectWithBorder();
            Rect2i rect = recipeLayout.getRect();
            recipeLayout.setPosition(recipeXOffset - rectWithBorder.getX() + rect.getX(), recipeYOffset - rectWithBorder.getY() + rect.getY());
            recipeYOffset += spacingY;
        }
        this.updateRecipeButtonPositions();
        this.nextPage.active = this.previousPage.active = this.logic.hasMultiplePages();
        this.nextRecipeCategory.active = this.previousRecipeCategory.active = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area);
        this.recipeGuiTabs.initLayout(this.idealArea);
    }

    private int getRecipeXOffset(ImmutableRect2i layoutRect, ImmutableRect2i layoutsArea) {
        int recipeWidth = layoutRect.getWidth();
        int recipeWidthWithButtons = this.recipeLayouts.isEmpty() ? layoutRect.getWidth() : this.layoutWidthWithButtons(this.recipeLayouts.getFirst());
        int buttonSpace = recipeWidthWithButtons - recipeWidth;
        int availableArea = layoutsArea.getWidth();
        if (availableArea > recipeWidth + 2 * buttonSpace) {
            return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidth) / 2;
        }
        return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidthWithButtons) / 2;
    }

    private ImmutableRect2i getRecipeLayoutsArea() {
        return new ImmutableRect2i(this.area.getX() + 6, this.area.getY() + this.headerHeight + 2, this.area.getWidth() - 12, this.area.getHeight() - (this.headerHeight + 6 + 2));
    }

    private void addRecipeButtons(List<IRecipeLayoutDrawable<?>> recipeLayouts) {
        if (this.minecraft == null) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        for (GuiEventListener guiEventListener : this.recipeTransferButtons.values()) {
            this.removeWidget(guiEventListener);
        }
        this.recipeTransferButtons.clear();
        for (GuiEventListener guiEventListener : this.recipeBookmarkButtons.values()) {
            this.removeWidget(guiEventListener);
        }
        this.recipeBookmarkButtons.clear();
        AbstractContainerMenu container = this.getParentContainer().orElse(null);
        for (IRecipeLayoutDrawable<?> recipeLayout : recipeLayouts) {
            Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
            Rect2i layoutArea = recipeLayout.getRect();
            buttonArea.setX(buttonArea.getX() + layoutArea.getX());
            buttonArea.setY(buttonArea.getY() + layoutArea.getY());
            IDrawableStatic icon = this.textures.getRecipeTransfer();
            RecipeTransferButton button3 = new RecipeTransferButton(icon, recipeLayout, this.textures, this::onClose);
            button3.setArea(buttonArea);
            button3.update(this.recipeTransferManager, container, (Player)player);
            this.addRenderableWidget((GuiEventListener)button3);
            this.recipeTransferButtons.put(recipeLayout, button3);
            RecipeBookmarkButton.create(recipeLayout, this.ingredientManager, this.bookmarks, this.textures, this.recipeManager, this.guiHelper).ifPresent(button -> {
                this.addRenderableWidget((GuiEventListener)button);
                this.recipeBookmarkButtons.put(recipeLayout, (RecipeBookmarkButton)((Object)((Object)button)));
            });
        }
    }

    private void updateRecipeButtonPositions() {
        for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
            Rect2i layoutArea;
            Rect2i buttonArea;
            GuiIconButtonSmall button = this.recipeTransferButtons.get(recipeLayout);
            if (button != null) {
                buttonArea = recipeLayout.getRecipeTransferButtonArea();
                layoutArea = recipeLayout.getRect();
                buttonArea.setX(buttonArea.getX() + layoutArea.getX());
                buttonArea.setY(buttonArea.getY() + layoutArea.getY());
                button.setArea(buttonArea);
            }
            if ((button = this.recipeBookmarkButtons.get(recipeLayout)) == null) continue;
            buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
            layoutArea = recipeLayout.getRect();
            buttonArea.setX(buttonArea.getX() + layoutArea.getX());
            buttonArea.setY(buttonArea.getY() + layoutArea.getY());
            button.setArea(buttonArea);
        }
    }

    private Optional<AbstractContainerMenu> getParentContainer() {
        Screen screen = this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = screen2.getMenu();
            return Optional.of(menu);
        }
        return Optional.empty();
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        int extraWidth = this.getRecipeCatalystExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.width, this.height);
    }
}

