/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.lookups.IFocusedRecipes;
import mezz.jei.gui.recipes.lookups.ILookupState;
import mezz.jei.gui.recipes.lookups.IngredientLookupState;
import mezz.jei.gui.recipes.lookups.SingleCategoryLookupState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final IRecipeManager recipeManager;
    private final IRecipeTransferManager recipeTransferManager;
    private final IRecipeLogicStateListener stateListener;
    private boolean initialState = true;
    private ILookupState state;
    private final Stack<ILookupState> history = new Stack();
    private final IFocusFactory focusFactory;

    public RecipeGuiLogic(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IRecipeLogicStateListener stateListener, IFocusFactory focusFactory) {
        this.recipeManager = recipeManager;
        this.recipeTransferManager = recipeTransferManager;
        this.stateListener = stateListener;
        this.state = IngredientLookupState.createWithFocus(recipeManager, focusFactory.getEmptyFocusGroup());
        this.focusFactory = focusFactory;
    }

    @Override
    public boolean showFocus(IFocusGroup focuses) {
        ILookupState state = IngredientLookupState.createWithFocus(this.recipeManager, focuses);
        return this.showState(state);
    }

    @Override
    public boolean showRecipes(IFocusedRecipes<?> recipes, IFocusGroup focuses) {
        SingleCategoryLookupState state = new SingleCategoryLookupState(recipes, focuses);
        return this.showState(state);
    }

    private boolean showState(ILookupState state) {
        List<IRecipeCategory<?>> recipeCategories = state.getRecipeCategories();
        if (recipeCategories.isEmpty()) {
            return false;
        }
        int recipeCategoryIndex = RecipeGuiLogic.getRecipeCategoryIndexToShowFirst(recipeCategories, this.recipeTransferManager);
        state.moveToRecipeCategoryIndex(recipeCategoryIndex);
        this.setState(state, true);
        return true;
    }

    @Nonnegative
    private static int getRecipeCategoryIndexToShowFirst(List<IRecipeCategory<?>> recipeCategories, IRecipeTransferManager recipeTransferManager) {
        AbstractContainerMenu openContainer;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && (openContainer = player.containerMenu) != null) {
            for (int i = 0; i < recipeCategories.size(); ++i) {
                IRecipeCategory<?> recipeCategory = recipeCategories.get(i);
                Optional<IRecipeTransferHandler<AbstractContainerMenu, ?>> recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(openContainer, recipeCategory);
                if (!recipeTransferHandler.isPresent()) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        ILookupState state = this.history.pop();
        this.setState(state, false);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private void setState(ILookupState state, boolean saveHistory) {
        if (saveHistory && !this.initialState) {
            this.history.push(this.state);
        }
        this.state = state;
        this.initialState = false;
        this.stateListener.onStateChange();
    }

    @Override
    public boolean showAllRecipes() {
        IRecipeCategory<?> recipeCategory = this.getSelectedRecipeCategory();
        ILookupState state = IngredientLookupState.createWithFocus(this.recipeManager, this.focusFactory.getEmptyFocusGroup());
        state.moveToRecipeCategory(recipeCategory);
        this.setState(state, true);
        return true;
    }

    @Override
    public boolean showCategories(List<RecipeType<?>> recipeTypes) {
        List<IRecipeCategory<?>> recipeCategories = this.recipeManager.createRecipeCategoryLookup().limitTypes(recipeTypes).get().toList();
        ILookupState state = IngredientLookupState.createWithCategories(this.recipeManager, this.focusFactory, recipeCategories);
        if (state.getRecipeCategories().isEmpty()) {
            return false;
        }
        this.setState(state, true);
        return true;
    }

    @Override
    public Stream<ITypedIngredient<?>> getRecipeCatalysts() {
        IRecipeCategory<?> category = this.getSelectedRecipeCategory();
        return this.getRecipeCatalysts(category);
    }

    @Override
    public Stream<ITypedIngredient<?>> getRecipeCatalysts(IRecipeCategory<?> recipeCategory) {
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        return this.recipeManager.createRecipeCatalystLookup(recipeType).get();
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state.getRecipesPerPage() != recipesPerPage) {
            this.state.setRecipesPerPage(recipesPerPage);
        }
    }

    @Override
    public IRecipeCategory<?> getSelectedRecipeCategory() {
        return this.state.getFocusedRecipes().getRecipeCategory();
    }

    @Override
    public @Unmodifiable List<IRecipeCategory<?>> getRecipeCategories() {
        return this.state.getRecipeCategories();
    }

    @Override
    public List<IRecipeLayoutDrawable<?>> getRecipeLayouts() {
        return this.getRecipeLayouts(this.state.getFocusedRecipes());
    }

    @Override
    public Optional<ImmutableRect2i> getRecipeLayoutSizeWithBorder() {
        return this.getRecipeLayoutSizeWithBorder(this.state.getFocusedRecipes());
    }

    private <T> Optional<ImmutableRect2i> getRecipeLayoutSizeWithBorder(IFocusedRecipes<T> selectedRecipes) {
        IRecipeCategory recipeCategory = selectedRecipes.getRecipeCategory();
        return selectedRecipes.getRecipes().stream().map(recipe -> this.recipeManager.createRecipeLayoutDrawable(recipeCategory, recipe, this.state.getFocuses())).flatMap(Optional::stream).map(IRecipeLayoutDrawable::getRectWithBorder).map(ImmutableRect2i::new).findFirst();
    }

    private <T> List<IRecipeLayoutDrawable<?>> getRecipeLayouts(IFocusedRecipes<T> selectedRecipes) {
        int firstRecipeIndex;
        ArrayList recipeLayouts = new ArrayList();
        IRecipeCategory<T> recipeCategory = selectedRecipes.getRecipeCategory();
        List<T> recipes = selectedRecipes.getRecipes();
        ArrayList brokenRecipes = new ArrayList();
        for (int recipeIndex = firstRecipeIndex = this.state.getRecipeIndex() - this.state.getRecipeIndex() % this.state.getRecipesPerPage(); recipeIndex < recipes.size() && recipeLayouts.size() < this.state.getRecipesPerPage(); ++recipeIndex) {
            Object recipe = recipes.get(recipeIndex);
            this.recipeManager.createRecipeLayoutDrawable(recipeCategory, recipe, this.state.getFocuses()).ifPresentOrElse(recipeLayouts::add, () -> brokenRecipes.add(recipe));
        }
        if (!brokenRecipes.isEmpty()) {
            RecipeType<T> recipeType = recipeCategory.getRecipeType();
            this.recipeManager.hideRecipes(recipeType, brokenRecipes);
        }
        return recipeLayouts;
    }

    @Override
    public void nextRecipeCategory() {
        this.state.nextRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory<?> category) {
        if (this.state.moveToRecipeCategory(category)) {
            this.stateListener.onStateChange();
        }
    }

    @Override
    public boolean hasMultiplePages() {
        List<?> recipes = this.state.getFocusedRecipes().getRecipes();
        return recipes.size() > this.state.getRecipesPerPage();
    }

    @Override
    public void previousRecipeCategory() {
        this.state.previousRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        this.state.nextPage();
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        this.state.previousPage();
        this.stateListener.onStateChange();
    }

    @Override
    public String getPageString() {
        int pageIndex = MathUtil.divideCeil(this.state.getRecipeIndex() + 1, this.state.getRecipesPerPage());
        return pageIndex + "/" + this.state.pageCount();
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.getRecipeCategories().size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        long categoryCount = this.recipeManager.createRecipeCategoryLookup().get().count();
        return (long)this.state.getRecipeCategories().size() == categoryCount;
    }
}

