/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.util.FocusUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class RecipeBookmarkElement<T, R>
implements IElement<R> {
    private final RecipeBookmark<T, R> recipeBookmark;
    private final IDrawable icon;

    public RecipeBookmarkElement(RecipeBookmark<T, R> recipeBookmark, IDrawable icon) {
        this.recipeBookmark = recipeBookmark;
        this.icon = icon;
    }

    @Override
    public ITypedIngredient<R> getTypedIngredient() {
        return this.recipeBookmark.getRecipeOutput();
    }

    @Override
    public Optional<IBookmark> getBookmark() {
        return Optional.of(this.recipeBookmark);
    }

    @Override
    public void renderExtras(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(8.0f, 8.0f, 200.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.icon.draw(guiGraphics);
        poseStack.popPose();
    }

    @Override
    public void show(IRecipesGui recipesGui, FocusUtil focusUtil, List<RecipeIngredientRole> roles) {
        IRecipeCategory<T> recipeCategory = this.recipeBookmark.getRecipeCategory();
        T recipe = this.recipeBookmark.getRecipe();
        ITypedIngredient<R> ingredient = this.getTypedIngredient();
        List<IFocus<?>> focuses = focusUtil.createFocuses(ingredient, List.of(RecipeIngredientRole.OUTPUT));
        recipesGui.showRecipes(recipeCategory, List.of(recipe), focuses);
    }

    @Override
    public List<Component> getTooltip(IngredientGridTooltipHelper tooltipHelper, IIngredientRenderer<R> ingredientRenderer, IIngredientHelper<R> ingredientHelper) {
        ITypedIngredient<R> ingredient = this.recipeBookmark.getRecipeOutput();
        return tooltipHelper.getRecipeTooltip(this.recipeBookmark.getRecipeCategory(), this.recipeBookmark.getRecipe(), ingredient, ingredientRenderer, ingredientHelper);
    }
}

