/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.search.SearchMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public final class IngredientGridTooltipHelper {
    private final IIngredientManager ingredientManager;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IClientToggleState toggleState;
    private final IModIdHelper modIdHelper;
    private final IInternalKeyMappings keyBindings;
    private final IColorHelper colorHelper;

    public IngredientGridTooltipHelper(IIngredientManager ingredientManager, IIngredientFilterConfig ingredientFilterConfig, IClientToggleState toggleState, IModIdHelper modIdHelper, IInternalKeyMappings keyBindings, IColorHelper colorHelper) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.toggleState = toggleState;
        this.modIdHelper = modIdHelper;
        this.keyBindings = keyBindings;
        this.colorHelper = colorHelper;
    }

    public <T> List<Component> getIngredientTooltip(ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        List<Component> tooltip = SafeIngredientUtil.getTooltip(this.ingredientManager, ingredientRenderer, typedIngredient);
        tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, typedIngredient.getIngredient(), ingredientHelper);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, typedIngredient, ingredientHelper);
        }
        if (this.toggleState.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
        return tooltip;
    }

    public <T, R> List<Component> getRecipeTooltip(IRecipeCategory<T> recipeCategory, T recipe, ITypedIngredient<R> recipeOutput, IIngredientRenderer<R> ingredientRenderer, IIngredientHelper<R> ingredientHelper) {
        ResourceLocation ingredientName;
        String ingredientModId;
        String recipeModId;
        List<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)"jei.tooltip.bookmarks.recipe", (Object[])new Object[]{recipeCategory.getTitle()}));
        ResourceLocation recipeName = recipeCategory.getRegistryName(recipe);
        if (recipeName != null && !(recipeModId = recipeName.getNamespace()).equals(ingredientModId = (ingredientName = ingredientHelper.getResourceLocation(recipeOutput.getIngredient())).getNamespace())) {
            String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
            MutableComponent recipeBy = Component.translatable((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
            tooltip.add((Component)recipeBy.withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.empty());
        List<Component> outputTooltip = SafeIngredientUtil.getTooltip(this.ingredientManager, ingredientRenderer, recipeOutput);
        tooltip.addAll(outputTooltip);
        tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, recipeOutput.getIngredient(), ingredientHelper);
        return tooltip;
    }

    private <T> void addColorSearchInfoToTooltip(List<Component> tooltip, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(typedIngredient.getIngredient());
        String colorNamesString = StreamSupport.stream(colors.spliterator(), false).map(this.colorHelper::getClosestColorName).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            MutableComponent colorTranslation = Component.translatable((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(List<Component> tooltip, IInternalKeyMappings keyBindings) {
        List<MutableComponent> lines = List.of(CommonComponents.EMPTY, Component.translatable((String)"gui.jei.editMode.description").withStyle(ChatFormatting.DARK_GREEN), Component.translatable((String)"gui.jei.editMode.description.hide", (Object[])new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.jei.editMode.description.hide.wild", (Object[])new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY));
        tooltip.addAll(lines);
    }
}

