/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInputRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CombinedInputHandler combinedInputHandler;
    private final Map<InputConstants.Key, IUserInputHandler> pending = new HashMap<InputConstants.Key, IUserInputHandler>();

    public UserInputRouter(IUserInputHandler ... inputHandlers) {
        this.combinedInputHandler = new CombinedInputHandler(inputHandlers);
    }

    public boolean handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Received user input: {}", (Object)input);
        }
        return switch (input.getClickState()) {
            default -> throw new MatchException(null, null);
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, input, keyBindings);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, input, keyBindings);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, input, keyBindings);
        };
    }

    private boolean handleImmediateClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Canceled previous user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Immediate click handled by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleSimulateClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("Canceled pending user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            this.pending.put(input.getKey(), (IUserInputHandler)callback);
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Click successfully simulated by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleExecuteClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        return Optional.ofNullable(this.pending.remove(input.getKey())).flatMap(inputHandler -> inputHandler.handleUserInput(screen, input, keyBindings)).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Click successfully executed by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    public void handleGuiChange() {
        if (DebugConfig.isDebugInputsEnabled()) {
            LOGGER.debug("The GUI has changed, clearing all pending clicks");
        }
        for (InputConstants.Key key : this.pending.keySet()) {
            this.combinedInputHandler.handleMouseClickedOut(key);
        }
        this.pending.clear();
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.combinedInputHandler.handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY).map(callback -> {
            if (DebugConfig.isDebugInputsEnabled()) {
                LOGGER.debug("Scroll handled by: {}", callback);
            }
            return true;
        }).orElse(false);
    }
}

