/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;

public class GuiIconButtonSmall
extends Button {
    private final IDrawable icon;
    private final Textures textures;

    public GuiIconButtonSmall(int x, int y, int widthIn, int heightIn, IDrawable icon, Button.OnPress pressable, Textures textures) {
        super(x, y, widthIn, heightIn, CommonComponents.EMPTY, pressable, Button.DEFAULT_NARRATION);
        this.icon = icon;
        this.textures = textures;
    }

    public ImmutableRect2i getArea() {
        return new ImmutableRect2i(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hovered = this.isMouseOver(mouseX, mouseY);
        DrawableNineSliceTexture texture = this.textures.getButtonForState(this.active, hovered);
        texture.draw(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int color = -2039584;
        if (!this.active) {
            color = -6250336;
        } else if (hovered) {
            color = -1;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float blue = (float)(color >> 8 & 0xFF) / 255.0f;
        float green = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)blue, (float)green, (float)alpha);
        double xOffset = (double)this.getX() + (double)(this.getWidth() - this.icon.getWidth()) / 2.0;
        double yOffset = (double)this.getY() + (double)(this.getHeight() - this.icon.getHeight()) / 2.0;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(xOffset, yOffset, 0.0);
        this.icon.draw(guiGraphics);
        poseStack.popPose();
    }

    public void setArea(Rect2i buttonArea) {
        this.setX(buttonArea.getX());
        this.setY(buttonArea.getY());
        this.setWidth(buttonArea.getWidth());
        this.setHeight(buttonArea.getHeight());
    }
}

