/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.TypedIngredientSerializer;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import mezz.jei.gui.config.file.serializers.RecipeBookmarkSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_STACK = "T:";
    private static final String MARKER_INGREDIENT = "I:";
    private static final String LEGACY_MARKER_OTHER = "O:";
    private static final String MARKER_RECIPE = "R:";
    private final Path jeiConfigurationDir;

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create bookmark config folder: {}", configPath);
                return Optional.empty();
            }
            Path path = configPath.resolve("bookmarks.ini");
            return Optional.of(path);
        });
    }

    public BookmarkConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    @Override
    public void saveBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, List<IBookmark> bookmarks) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
            RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer, guiHelper);
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            for (IBookmark bookmark : bookmarks) {
                if (bookmark instanceof IngredientBookmark) {
                    IngredientBookmark ingredientBookmark = (IngredientBookmark)bookmark;
                    ITypedIngredient typedIngredient = ingredientBookmark.getIngredient();
                    Object patt0$temp = typedIngredient.getIngredient();
                    if (patt0$temp instanceof ItemStack) {
                        ItemStack stack = (ItemStack)patt0$temp;
                        strings.add((CallSite)((Object)(MARKER_STACK + String.valueOf(stack.save((HolderLookup.Provider)registryAccess)))));
                        continue;
                    }
                    strings.add((CallSite)((Object)(MARKER_INGREDIENT + ingredientSerializer.serialize(typedIngredient))));
                    continue;
                }
                if (bookmark instanceof RecipeBookmark) {
                    RecipeBookmark recipeBookmark = (RecipeBookmark)bookmark;
                    strings.add((CallSite)((Object)(MARKER_RECIPE + recipeBookmarkSerializer.serialize(recipeBookmark))));
                    continue;
                }
                LOGGER.error("Unknown IBookmark type, unable to save it: {}", bookmark.getClass());
            }
            try {
                Files.write(path, strings, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save bookmarks list to file {}", path, (Object)e);
            }
        });
    }

    @Override
    public void loadBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, BookmarkList bookmarkList) {
        BookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> {
            List<String> lines;
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            try {
                lines = Files.readAllLines(path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load bookmarks from file {}", path, (Object)e);
                return;
            }
            TypedIngredientSerializer ingredientSerializer = new TypedIngredientSerializer(ingredientManager);
            RecipeBookmarkSerializer recipeBookmarkSerializer = new RecipeBookmarkSerializer(recipeManager, focusFactory, ingredientSerializer, guiHelper);
            List<IIngredientType<?>> otherIngredientTypes = ingredientManager.getRegisteredIngredientTypes().stream().filter(i -> !i.equals(VanillaTypes.ITEM_STACK)).toList();
            IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
            for (String line : lines) {
                if (line.startsWith(MARKER_STACK)) {
                    String itemStackAsJson = line.substring(MARKER_STACK.length());
                    BookmarkConfig.loadItemStackBookmark(registryAccess, itemStackHelper, ingredientManager, itemStackAsJson, bookmarkList);
                    continue;
                }
                if (line.startsWith(MARKER_INGREDIENT)) {
                    String serializedIngredient = line.substring(MARKER_INGREDIENT.length());
                    BookmarkConfig.loadIngredientBookmark(ingredientSerializer, ingredientManager, serializedIngredient, bookmarkList);
                    continue;
                }
                if (line.startsWith(LEGACY_MARKER_OTHER)) {
                    String uid = line.substring(LEGACY_MARKER_OTHER.length());
                    BookmarkConfig.loadLegacyIngredientBookmark(otherIngredientTypes, ingredientManager, uid, bookmarkList);
                    continue;
                }
                if (line.startsWith(MARKER_RECIPE)) {
                    String serializedRecipe = line.substring(MARKER_RECIPE.length());
                    BookmarkConfig.loadRecipeBookmark(recipeBookmarkSerializer, serializedRecipe, bookmarkList);
                    continue;
                }
                LOGGER.error("Failed to load unknown bookmark type:\n{}", (Object)line);
            }
            bookmarkList.notifyListenersOfChange();
        });
    }

    private static void loadItemStackBookmark(RegistryAccess registryAccess, IIngredientHelper<ItemStack> itemStackHelper, IIngredientManager ingredientManager, String itemStackAsJson, BookmarkList bookmarkList) {
        try {
            CompoundTag itemStackAsNbt = TagParser.parseTag((String)itemStackAsJson);
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)itemStackAsNbt);
            if (!itemStack.isEmpty()) {
                ItemStack normalized = itemStackHelper.normalizeIngredient(itemStack);
                Optional<ITypedIngredient<ItemStack>> typedIngredient = ingredientManager.createTypedIngredient(VanillaTypes.ITEM_STACK, normalized);
                if (typedIngredient.isEmpty()) {
                    LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                } else {
                    IngredientBookmark<ItemStack> bookmark = IngredientBookmark.create(typedIngredient.get(), ingredientManager);
                    bookmarkList.addToList(bookmark, false);
                }
            } else {
                LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item is empty:\n{}", (Object)itemStackAsJson);
            }
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
        }
    }

    private static void loadIngredientBookmark(TypedIngredientSerializer ingredientSerializer, IIngredientManager ingredientManager, String serializedIngredient, BookmarkList bookmarkList) {
        IJeiConfigValueSerializer.IDeserializeResult<ITypedIngredient<?>> deserialized = ingredientSerializer.deserialize(serializedIngredient);
        Optional<ITypedIngredient<?>> result = deserialized.getResult();
        if (result.isEmpty()) {
            List<String> errors = deserialized.getErrors();
            LOGGER.warn("Failed to load bookmarked ingredients from string: \n{}\n{}", (Object)serializedIngredient, (Object)String.join((CharSequence)", ", errors));
        } else {
            IngredientBookmark<?> bookmark = IngredientBookmark.create(result.get(), ingredientManager);
            bookmarkList.addToList(bookmark, false);
        }
    }

    private static void loadLegacyIngredientBookmark(Collection<IIngredientType<?>> otherIngredientTypes, IIngredientManager ingredientManager, String uid, BookmarkList bookmarkList) {
        Optional<ITypedIngredient<?>> typedIngredient = BookmarkConfig.getLegacyNormalizedIngredientByUid(ingredientManager, otherIngredientTypes, uid);
        if (typedIngredient.isEmpty()) {
            LOGGER.error("Failed to load unknown bookmarked ingredient with uid:\n{}", (Object)uid);
        } else {
            IngredientBookmark<?> bookmark = IngredientBookmark.create(typedIngredient.get(), ingredientManager);
            bookmarkList.addToList(bookmark, false);
        }
    }

    private static void loadRecipeBookmark(RecipeBookmarkSerializer recipeBookmarkSerializer, String serializedRecipe, BookmarkList bookmarkList) {
        IJeiConfigValueSerializer.IDeserializeResult<RecipeBookmark<?, ?>> deserialized = recipeBookmarkSerializer.deserialize(serializedRecipe);
        Optional<RecipeBookmark<?, ?>> result = deserialized.getResult();
        if (result.isEmpty()) {
            List<String> errors = deserialized.getErrors();
            LOGGER.warn("Failed to load bookmarked recipe from string: \n{}\n{}", (Object)serializedRecipe, (Object)String.join((CharSequence)", ", errors));
        } else {
            bookmarkList.addToList(result.get(), false);
        }
    }

    private static Optional<ITypedIngredient<?>> getLegacyNormalizedIngredientByUid(IIngredientManager ingredientManager, Collection<IIngredientType<?>> ingredientTypes, String uid) {
        return ingredientTypes.stream().map(t -> ingredientManager.getTypedIngredientByUid(t, uid)).flatMap(Optional::stream).findFirst();
    }
}

