/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.core.RegistryAccess;

public class BookmarkList
implements IIngredientGridSource {
    private final List<IBookmark> bookmarks = new LinkedList<IBookmark>();
    private final IRecipeManager recipeManager;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private final RegistryAccess registryAccess;
    private final IBookmarkConfig bookmarkConfig;
    private final IClientConfig clientConfig;
    private final IGuiHelper guiHelper;
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();

    public BookmarkList(IRecipeManager recipeManager, IFocusFactory focusFactory, IIngredientManager ingredientManager, RegistryAccess registryAccess, IBookmarkConfig bookmarkConfig, IClientConfig clientConfig, IGuiHelper guiHelper) {
        this.recipeManager = recipeManager;
        this.focusFactory = focusFactory;
        this.ingredientManager = ingredientManager;
        this.registryAccess = registryAccess;
        this.bookmarkConfig = bookmarkConfig;
        this.clientConfig = clientConfig;
        this.guiHelper = guiHelper;
    }

    public boolean add(IBookmark value) {
        if (this.contains(value)) {
            return false;
        }
        this.addToList(value, this.clientConfig.isAddingBookmarksToFrontEnabled());
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.recipeManager, this.focusFactory, this.guiHelper, this.ingredientManager, this.registryAccess, this.bookmarks);
        return true;
    }

    public boolean contains(IBookmark value) {
        return this.bookmarks.contains(value);
    }

    public <T> boolean toggleBookmark(IElement<T> element) {
        IBookmark bookmark = element.getBookmark().orElseGet(() -> {
            ITypedIngredient ingredient = element.getTypedIngredient();
            return IngredientBookmark.create(ingredient, this.ingredientManager);
        });
        return this.toggleBookmark(bookmark);
    }

    public boolean toggleBookmark(IBookmark bookmark) {
        return this.remove(bookmark) || this.add(bookmark);
    }

    public boolean remove(IBookmark ingredient) {
        if (!this.bookmarks.remove(ingredient)) {
            return false;
        }
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.recipeManager, this.focusFactory, this.guiHelper, this.ingredientManager, this.registryAccess, this.bookmarks);
        return true;
    }

    public void addToList(IBookmark value, boolean addToFront) {
        if (addToFront) {
            this.bookmarks.addFirst(value);
        } else {
            this.bookmarks.add(value);
        }
    }

    @Override
    public List<IElement<?>> getElements() {
        return this.bookmarks.stream().map(IBookmark::getElement).toList();
    }

    public boolean isEmpty() {
        return this.bookmarks.isEmpty();
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }
}

