/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen.widgets;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.util.Mth;

public class EntryList<E extends ObjectSelectionList.Entry<E>>
extends ObjectSelectionList<E> {
    public static final int SCROLL_BAR_WIDTH = 6;

    public EntryList(int left, int top, int width, int height, int slotHeight) {
        super(Minecraft.getInstance(), width, height, top, slotHeight);
        this.setX(left);
        double guiScaleFactor = Minecraft.getInstance().getWindow().getGuiScale();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        this.renderParts(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.disableScissor();
    }

    private void renderParts(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        this.renderContentBackground(guiGraphics);
        int k = this.getRowLeft();
        int l = this.getY() + 4 - (int)this.getScrollAmount();
        int j1 = this.getMaxScroll();
        if (j1 > 0) {
            int k1 = (int)((float)((this.getBottom() - this.getY()) * (this.getBottom() - this.getY())) / (float)this.getMaxPosition());
            k1 = Mth.clamp((int)k1, (int)32, (int)(this.getBottom() - this.getY() - 8));
            int l1 = (int)this.getScrollAmount() * (this.getBottom() - this.getY() - k1) / j1 + this.getY();
            if (l1 < this.getY()) {
                l1 = this.getY();
            }
            int x1 = this.getScrollbarPosition();
            int x2 = x1 + 6;
            bufferbuilder.addVertex((float)x1, (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            bufferbuilder.addVertex((float)x2, (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            bufferbuilder.addVertex((float)x2, (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
            bufferbuilder.addVertex((float)x1, (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
            bufferbuilder.addVertex((float)x1, (float)(l1 + k1), 0.0f).setColor(128, 128, 128, 255);
            bufferbuilder.addVertex((float)x2, (float)(l1 + k1), 0.0f).setColor(128, 128, 128, 255);
            bufferbuilder.addVertex((float)x2, (float)l1, 0.0f).setColor(128, 128, 128, 255);
            bufferbuilder.addVertex((float)x1, (float)l1, 0.0f).setColor(128, 128, 128, 255);
            bufferbuilder.addVertex((float)x1, (float)(l1 + k1 - 1), 0.0f).setColor(192, 192, 192, 255);
            bufferbuilder.addVertex((float)(x2 - 1), (float)(l1 + k1 - 1), 0.0f).setColor(192, 192, 192, 255);
            bufferbuilder.addVertex((float)(x2 - 1), (float)l1, 0.0f).setColor(192, 192, 192, 255);
            bufferbuilder.addVertex((float)x1, (float)l1, 0.0f).setColor(192, 192, 192, 255);
        }
        this.renderListItems(guiGraphics, k, l, partialTicks);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    protected void renderContentBackground(GuiGraphics guiGraphics) {
        guiGraphics.fillGradient(this.getX(), this.getY(), this.getRight(), this.getBottom(), -1072689136, -804253680);
    }

    protected void renderSelection(GuiGraphics p_283589_, int p_240142_, int p_240143_, int p_240144_, int p_240145_, int p_240146_) {
        int i = this.getX() + 3;
        int j = this.getX() + (this.width + p_240143_) / 2;
        p_283589_.fill(i, p_240142_ - 2, j, p_240142_ + p_240144_ + 2, p_240145_);
        p_283589_.fill(i + 1, p_240142_ - 1, j - 1, p_240142_ + p_240144_ + 1, p_240146_);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.setDragging(true);
        super.mouseClicked(x, y, button);
        return this.isMouseOver(x, y);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.setDragging(false);
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (super.mouseDragged(x, y, button, dx, dy)) {
            return true;
        }
        if (this.isMouseOver(x, y)) {
            this.setScrollAmount(this.getScrollAmount() - dy);
        }
        return true;
    }

    public final int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4));
    }

    public int getRowWidth() {
        return this.getWidth() - 30;
    }
}

