/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.PlatformBindings;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.Hint;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyMappings;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TrashSlotGuiHandler {
    private static final TrashSlotSlot trashSlot = new TrashSlotSlot();
    private static TrashSlotComponent trashSlotComponent;
    private static ContainerSettings currentContainerSettings;
    private static boolean ignoreMouseUp;
    private static boolean sentMissingMessage;
    private static boolean isLeftMouseDown;
    private static Hint currentHint;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, TrashSlotGuiHandler::onScreenInit);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, TrashSlotGuiHandler::onMouseRelease);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, TrashSlotGuiHandler::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, TrashSlotGuiHandler::onKeyPress);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onBackgroundDrawn);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onScreenDrawn);
    }

    private static void onScreenInit(ScreenInitEvent.Post event) {
        if (event.getScreen().getClass().getName().startsWith("com.replaymod")) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isSpectator()) {
            return;
        }
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (!TrashSlot.isServerSideInstalled && !sentMissingMessage) {
                TrashSlot.logger.info("TrashSlot is not installed on the server and thus will be unavailable.");
                MutableComponent noHabloEspanol = Component.translatable((String)"trashslot.serverNotInstalled");
                noHabloEspanol.withStyle(ChatFormatting.RED);
                TrashSlotGuiHandler.showHint("serverNotInstalled", noHabloEspanol, 5000, true);
                sentMissingMessage = true;
                return;
            }
            if (screen2 instanceof InventoryScreen && player != null && player.getAbilities().instabuild) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(screen2);
            currentContainerSettings = TrashSlotSaveState.getSettings(screen2, layout);
            if (currentContainerSettings != ContainerSettings.NONE) {
                trashSlotComponent = new TrashSlotComponent(screen2, layout, currentContainerSettings, trashSlot);
                if (!currentContainerSettings.isEnabled() && !layout.isEnabledByDefault()) {
                    MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.toggleOn", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getTranslatedKeyMessage()});
                    TrashSlotGuiHandler.showHint("toggleOn", hintMessage, 5000);
                }
            } else {
                trashSlotComponent = null;
            }
        } else {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
        }
    }

    private static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            event.setCanceled(true);
            ignoreMouseUp = false;
        }
    }

    private static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        DeletionProvider deletionProvider;
        if (event.getButton() == 0) {
            isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        int mouseButton = event.getButton();
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), InputConstants.Type.MOUSE, mouseButton, 0)) {
            event.setCanceled(true);
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            double mouseY;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            double mouseX = event.getMouseX();
            if (((AbstractContainerScreenAccessor)screen2).callIsHovering((Slot)trashSlot, mouseX, mouseY = event.getMouseY())) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    boolean isRightClick;
                    ItemStack mouseItem = screen2.getMenu().getCarried();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.isEmpty()) {
                        deletionProvider.undeleteLast((Player)player, trashSlot, isRightClick);
                    } else {
                        ResourceLocation registryName = Balm.getRegistries().getKey(mouseItem.getItem());
                        if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                            deletionProvider.deleteMouseItem((Player)player, mouseItem, trashSlot, isRightClick);
                        } else {
                            MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletionDenied");
                            hintMessage.withStyle(ChatFormatting.RED);
                            TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                        }
                    }
                    event.setCanceled(true);
                    ignoreMouseUp = true;
                }
            } else if (trashSlotComponent.isInside((int)mouseX, (int)mouseY)) {
                event.setCanceled(true);
                ignoreMouseUp = true;
            }
        }
    }

    private static void onKeyPress(ScreenKeyEvent.Press.Post event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return;
        }
        int keyCode = event.getKey();
        int scanCode = event.getScanCode();
        InputConstants.Key input = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), input.getType(), keyCode, scanCode)) {
            event.setCanceled(true);
        }
    }

    private static boolean runKeyBindings(Screen screen, InputConstants.Type type, int keyCode, int scanCode) {
        Slot mouseSlot;
        CreativeModeInventoryScreen containerScreen;
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        boolean isDelete = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDelete, type, keyCode, scanCode);
        boolean isDeleteAll = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDeleteAll, type, keyCode, scanCode);
        if (isDelete && isDeleteAll && !PlatformBindings.INSTANCE.supportsKeyModifiers()) {
            isDelete = !Screen.hasShiftDown();
            isDeleteAll = Screen.hasShiftDown();
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if ((isDelete || isDeleteAll) && TrashSlotConfig.getActive().enableDeleteKeysInCreative && screen instanceof CreativeModeInventoryScreen) {
            containerScreen = (CreativeModeInventoryScreen)screen;
            if (player != null) {
                mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                DeletionProvider creativeDeletionProvider = TrashSlotConfig.getCreativeDeletionProvider();
                if (mouseSlot != null && mouseSlot.getClass() == Slot.class) {
                    creativeDeletionProvider.deleteContainerItem(containerScreen.getMenu(), mouseSlot.index - 9, isDeleteAll, trashSlot);
                } else if (mouseSlot != null && mouseSlot.getClass().getSimpleName().equals("SlotWrapper")) {
                    creativeDeletionProvider.deleteContainerItem(containerScreen.getMenu(), mouseSlot.getContainerSlot(), isDeleteAll, trashSlot);
                }
            }
        }
        if ((currentContainerSettings.isEnabled() || TrashSlotConfig.getActive().allowDeletionWhileTrashSlotIsInvisible) && (isDelete || isDeleteAll) && player != null && screen instanceof AbstractContainerScreen) {
            containerScreen = (AbstractContainerScreen)screen;
            mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (mouseSlot != null && mouseSlot.hasItem()) {
                ResourceLocation registryName = Balm.getRegistries().getKey(mouseSlot.getItem().getItem());
                if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                    deletionProvider.deleteContainerItem(containerScreen.getMenu(), mouseSlot.index, isDeleteAll, trashSlot);
                    if (!currentContainerSettings.isEnabled()) {
                        MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletedWhileHidden");
                        hintMessage.withStyle(ChatFormatting.GOLD);
                        TrashSlotGuiHandler.showHint("deletedWhileHidden", hintMessage, 800, true);
                    }
                } else {
                    MutableComponent hintMessage = Component.translatable((String)"trashslot.hint.deletionDenied");
                    hintMessage.withStyle(ChatFormatting.RED);
                    TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                }
            } else {
                double mouseY;
                Window mainWindow = Minecraft.getInstance().getWindow();
                double rawMouseX = Minecraft.getInstance().mouseHandler.xpos();
                double rawMouseY = Minecraft.getInstance().mouseHandler.ypos();
                double mouseX = rawMouseX * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getWidth();
                if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((Slot)trashSlot, mouseX, mouseY = rawMouseY * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getHeight())) {
                    deletionProvider.emptyTrashSlot(trashSlot);
                }
            }
            return true;
        }
        if (screen instanceof AbstractContainerScreen && currentContainerSettings != ContainerSettings.NONE) {
            MutableComponent hintMessage;
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindToggleSlot, type, keyCode, scanCode)) {
                currentContainerSettings.setEnabled(!currentContainerSettings.isEnabled());
                if (!currentContainerSettings.isEnabled()) {
                    hintMessage = Component.translatable((String)"trashslot.hint.toggledOff", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getTranslatedKeyMessage()});
                    TrashSlotGuiHandler.showHint("toggledOff", hintMessage, 5000);
                }
                TrashSlotSaveState.save();
                return true;
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindToggleSlotLock, type, keyCode, scanCode)) {
                currentContainerSettings.setLocked(!currentContainerSettings.isLocked());
                if (currentContainerSettings.isLocked()) {
                    hintMessage = Component.translatable((String)"trashslot.hint.locked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getTranslatedKeyMessage()});
                    hintMessage.withStyle(ChatFormatting.GOLD);
                    TrashSlotGuiHandler.showHint("locked", hintMessage, 5000, true);
                } else {
                    hintMessage = Component.translatable((String)"trashslot.hint.unlocked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getTranslatedKeyMessage()});
                    hintMessage.withStyle(ChatFormatting.GOLD);
                    TrashSlotGuiHandler.showHint("unlocked", hintMessage, 5000, true);
                }
                TrashSlotSaveState.save();
                return true;
            }
        }
        return false;
    }

    private static void showHint(String id, MutableComponent message, int timeToDisplay) {
        TrashSlotGuiHandler.showHint(id, message, timeToDisplay, false);
    }

    private static void showHint(String id, MutableComponent message, int timeToDisplay, boolean force) {
        TrashSlotSaveState saveState = TrashSlotSaveState.getInstance();
        if (force || !saveState.hasSeenHint(id) && TrashSlotConfig.getActive().enableHints) {
            currentHint = new Hint(id, (Component)message, timeToDisplay);
        }
    }

    public static void onBackgroundDrawn(ContainerScreenDrawEvent.Background event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (trashSlotComponent != null) {
                trashSlotComponent.update(event.getMouseX(), event.getMouseY());
                trashSlotComponent.drawBackground(event.getGuiGraphics());
                if (((AbstractContainerScreenAccessor)screen2).callIsHovering((Slot)trashSlot, (double)event.getMouseX(), (double)event.getMouseY())) {
                    PoseStack poseStack = event.getGuiGraphics().pose();
                    poseStack.pushPose();
                    poseStack.translate((float)((AbstractContainerScreenAccessor)screen2).getLeftPos(), (float)((AbstractContainerScreenAccessor)screen2).getTopPos(), 0.0f);
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)event.getGuiGraphics(), (int)TrashSlotGuiHandler.trashSlot.x, (int)TrashSlotGuiHandler.trashSlot.y, (int)0);
                    poseStack.popPose();
                }
            }
        }
    }

    public static void onScreenDrawn(ContainerScreenDrawEvent.Background event) {
        DeletionProvider deletionProvider;
        if (currentHint != null) {
            currentHint.render(event.getScreen(), event.getGuiGraphics());
            if (currentHint.isComplete()) {
                TrashSlotSaveState.getInstance().markHintAsSeen(currentHint.getId());
                TrashSlotSaveState.save();
                currentHint = null;
            }
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (trashSlotComponent != null) {
                TrashSlotSlot trashSlot = TrashSlotGuiHandler.trashSlot;
                SlotAccessor slotAccessor = (SlotAccessor)trashSlot;
                slotAccessor.setX(trashSlot.x + ((AbstractContainerScreenAccessor)screen2).getLeftPos());
                slotAccessor.setY(trashSlot.y + ((AbstractContainerScreenAccessor)screen2).getTopPos());
                ((AbstractContainerScreenAccessor)screen2).callRenderSlot(event.getGuiGraphics(), (Slot)trashSlot);
                slotAccessor.setX(trashSlot.x - ((AbstractContainerScreenAccessor)screen2).getLeftPos());
                slotAccessor.setY(trashSlot.y - ((AbstractContainerScreenAccessor)screen2).getTopPos());
                boolean isMouseSlot = ((AbstractContainerScreenAccessor)screen2).callIsHovering((Slot)trashSlot, (double)event.getMouseX(), (double)event.getMouseY());
                if (isMouseSlot && screen2.getMenu().getCarried().isEmpty() && trashSlot.hasItem()) {
                    event.getGuiGraphics().renderTooltip(Minecraft.getInstance().font, trashSlot.getItem(), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    public static TrashSlotComponent getTrashSlotComponent() {
        return trashSlotComponent;
    }

    public static TrashSlotSlot getTrashSlot() {
        return trashSlot;
    }

    public static boolean isLeftMouseDown() {
        return isLeftMouseDown;
    }

    static {
        currentContainerSettings = ContainerSettings.NONE;
    }
}

