/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.networking;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tallestegg.guardvillagers.common.entities.Guard;

public record GuardSetPatrolPosPacket(int entityId, boolean pressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuardSetPatrolPosPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"set_patrol"));
    public static final StreamCodec<FriendlyByteBuf, GuardSetPatrolPosPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GuardSetPatrolPosPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, GuardSetPatrolPosPacket::pressed, GuardSetPatrolPosPacket::new);

    public static void setPatrolPosition(GuardSetPatrolPosPacket packet, IPayloadContext context) {
        Entity entity;
        Player player = context.player();
        if (player != null && player.level() instanceof ServerLevel && (entity = player.level().getEntity(packet.entityId())) instanceof Guard) {
            BlockPos pos;
            Guard guard = (Guard)entity;
            BlockPos blockPos = pos = packet.pressed() ? null : guard.blockPosition();
            if (guard.blockPosition() != null) {
                guard.setPatrolPos(pos);
            }
            guard.setPatrolling(!packet.pressed());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

