/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.GuardEntityType;

public class HealGuardAndPlayerGoal
extends Goal {
    private final Mob healer;
    private LivingEntity mob;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    protected final TargetingConditions predicate = TargetingConditions.forNonCombat().range(64.0);

    public HealGuardAndPlayerGoal(Mob healer, double movespeed, int attackIntervalMin, int maxAttackTime, float maxAttackDistanceIn) {
        this.healer = healer;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = attackIntervalMin;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (((Villager)this.healer).getVillagerData().getProfession() != VillagerProfession.CLERIC || this.healer.isSleeping()) {
            return false;
        }
        List list = this.healer.level().getEntitiesOfClass(LivingEntity.class, this.healer.getBoundingBox().inflate(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (LivingEntity mob : list) {
                if (mob == null || !(mob instanceof Villager && mob.isAlive() && mob.getHealth() < mob.getMaxHealth() && mob != this.healer || mob.getType() == GuardEntityType.GUARD.get() && mob != null && mob.isAlive() && mob.getHealth() < mob.getMaxHealth()) && (!(mob instanceof Player) || !mob.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || ((Player)mob).getAbilities().instabuild || !(mob.getHealth() < mob.getMaxHealth()))) continue;
                this.mob = mob;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() && this.mob != null && this.mob.getHealth() < this.mob.getMaxHealth();
    }

    public void stop() {
        this.mob = null;
        this.seeTime = 0;
        this.healer.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.rangedAttackTime = 0;
    }

    public void tick() {
        if (this.mob == null) {
            return;
        }
        double d0 = this.healer.distanceToSqr(this.mob.getX(), this.mob.getY(), this.mob.getZ());
        boolean flag = this.healer.getSensing().hasLineOfSight((Entity)this.mob);
        this.seeTime = flag ? ++this.seeTime : 0;
        BehaviorUtils.lookAtEntity((LivingEntity)this.healer, (LivingEntity)this.mob);
        if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
            this.healer.getNavigation().stop();
        } else {
            this.healer.getNavigation().moveTo((Entity)this.healer, this.entityMoveSpeed);
        }
        if ((double)this.mob.distanceTo((Entity)this.healer) <= 3.0) {
            this.healer.getMoveControl().strafe(-0.5f, 0.0f);
        }
        if (--this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = this.attackRadius;
            float distanceFactor = Mth.clamp((float)f, (float)0.1f, (float)0.1f);
            this.throwPotion(this.mob, distanceFactor);
            this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            this.rangedAttackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.maxAttackDistance));
        }
    }

    public void throwPotion(LivingEntity target, float distanceFactor) {
        Vec3 vec3d = target.getDeltaMovement();
        double d0 = target.getX() + vec3d.x - this.healer.getX();
        double d1 = target.getEyeY() - (double)1.1f - this.healer.getY();
        double d2 = target.getZ() + vec3d.z - this.healer.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        Holder potion = target.getHealth() > 4.0f ? Potions.REGENERATION : Potions.HEALING;
        ThrownPotion potionentity = new ThrownPotion(this.healer.level(), (LivingEntity)this.healer);
        potionentity.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potion));
        potionentity.setXRot(-20.0f);
        potionentity.shoot(d0, d1 + (double)(f * 0.2f), d2, 0.75f, 8.0f);
        this.healer.level().playSound((Player)null, this.healer.getX(), this.healer.getY(), this.healer.getZ(), SoundEvents.SPLASH_POTION_THROW, this.healer.getSoundSource(), 1.0f, 0.8f + this.healer.getRandom().nextFloat() * 0.4f);
        this.healer.level().addFreshEntity((Entity)potionentity);
    }
}

