/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HealGolemGoal
extends Goal {
    public final Mob healer;
    public IronGolem golem;
    public boolean hasStartedHealing;

    public HealGolemGoal(Mob mob) {
        this.healer = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (((Villager)this.healer).getVillagerData().getProfession() != VillagerProfession.WEAPONSMITH && ((Villager)this.healer).getVillagerData().getProfession() != VillagerProfession.TOOLSMITH && ((Villager)this.healer).getVillagerData().getProfession() != VillagerProfession.ARMORER || this.healer.isSleeping()) {
            return false;
        }
        List list = this.healer.level().getEntitiesOfClass(IronGolem.class, this.healer.getBoundingBox().inflate(10.0));
        if (!list.isEmpty()) {
            for (IronGolem golem : list) {
                if (golem.isInvisible() || !golem.isAlive() || golem.getType() != EntityType.IRON_GOLEM || !((double)golem.getHealth() <= 60.0) && (!this.hasStartedHealing || !(golem.getHealth() < golem.getMaxHealth()))) continue;
                this.healer.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
                this.golem = golem;
                return true;
            }
        }
        return false;
    }

    public void stop() {
        this.healer.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.hasStartedHealing = false;
        super.stop();
    }

    public void start() {
        if (this.golem == null) {
            return;
        }
        this.healer.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
        this.healGolem();
    }

    public void tick() {
        if (this.golem.getHealth() < this.golem.getMaxHealth()) {
            this.healGolem();
        }
    }

    public void healGolem() {
        this.healer.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
        this.healer.getNavigation().moveTo((Entity)this.golem, 0.5);
        if ((double)this.healer.distanceTo((Entity)this.golem) <= 2.0) {
            this.hasStartedHealing = true;
            this.healer.swing(InteractionHand.MAIN_HAND);
            this.golem.heal(15.0f);
            float f1 = 1.0f + (this.golem.getRandom().nextFloat() - this.golem.getRandom().nextFloat()) * 0.2f;
            this.golem.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, f1);
        }
    }
}

