/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book.demo.features;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SpotlightEntry
extends EntryProvider {
    public static final String ID = "spotlight";

    public SpotlightEntry(CategoryProvider parent) {
        super(parent);
    }

    @Override
    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Spotlight Entry");
        this.pageText("Spotlight pages allow to show items (actually, ingredients).\n");
        this.page("spotlight1", () -> BookSpotlightPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE})));
        this.pageTitle("Custom Title");
        this.pageText("A sample spotlight page with custom title.\\\nIt shows how an {0} can be rendered with a little border and fancyness around it.\\\nI am adding this link to see if spotlight pages have an offset problem. \\\nThe entry needs to be longer to trigger scaling.\\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Sed sed odio eu dolor ornare tempor. In nibh erat, finibus sed eros id, finibus interdum justo. Aenean luctus, magna at pharetra accumsan, tellus libero tincidunt enim, id varius ante sem sit amet ipsum. \n", this.itemLink((ItemLike)Items.APPLE));
        this.page("spotlight2", () -> BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})));
        this.pageText("A sample spotlight page with automatic title.");
    }

    @Override
    protected String entryName() {
        return "Spotlight Entry";
    }

    @Override
    protected String entryDescription() {
        return "An entry showcasing spotlight pages.";
    }

    @Override
    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    @Override
    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.BEACON);
    }

    @Override
    protected String entryId() {
        return ID;
    }
}

