/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.LeafletEntryProvider;
import com.klikli_dev.modonomicon.api.datagen.LeafletSubProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.modonomicon.book.PageDisplayMode;

public class DemoLeaflet
extends LeafletSubProvider {
    public static final String ID = "demo_leaflet";

    public DemoLeaflet(String modId, ModonomiconLanguageProvider defaultLang) {
        super(ID, modId, defaultLang);
    }

    @Override
    protected LeafletEntryProvider createEntryProvider(CategoryProvider parent) {
        return new LeafletEntryProvider(this, parent){

            @Override
            protected void generatePages() {
                this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
                this.pageTitle("Demo Leaflet");
                this.pageText("This is a demo leaflet. It has some features:\n1. It's a leaflet. Yay.\n2. All page types modonomicon supports.\n3. No categories, no books, no mess.\n4. Fun! (If you like leaflets)\n");
                this.page("page2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
                this.pageTitle("A second page");
                this.pageText("Despite being a leaflet, it can have as many pages as you like!\n");
                this.page("page3", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
                this.pageTitle("A third page");
                this.pageText("Now just imagine a few more pages.\n");
            }
        };
    }

    @Override
    protected BookModel additionalLeafletSetup(BookModel book) {
        return book.withBookTextOffsetWidth(-5).withBookTextOffsetX(5).withPageDisplayMode(PageDisplayMode.SINGLE_PAGE);
    }

    @Override
    protected void registerDefaultMacros() {
    }

    @Override
    protected String bookName() {
        return "Demo Leaflet";
    }

    @Override
    protected String bookTooltip() {
        return "A simple leaflet to show how modonomicon handles those.";
    }
}

