/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.MarkdownComponentRenderUtils;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class BookPageRenderer<T extends BookPage> {
    public int left;
    public int top;
    protected T page;
    protected BookEntryScreen parentScreen;
    protected Minecraft mc;
    protected Font font;
    private List<Button> buttons = new ArrayList<Button>();

    public BookPageRenderer(T page) {
        this.page = page;
    }

    public static float getBookTextHolderScaleForRenderSize(BookTextHolder text, Font font, int width, int height) {
        if (width <= 0 || height <= 0) {
            return 1.0f;
        }
        if (!(text instanceof RenderedBookTextHolder)) {
            return 1.0f;
        }
        RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
        float cachedScale = BookDataManager.Client.get().getScale(text, width, height);
        if (cachedScale > -1.0f) {
            return cachedScale;
        }
        List<MutableComponent> components = renderedText.getRenderedText();
        float granularity = 0.01f;
        float scale = 1.0f;
        float totalHeight = 0.0f;
        do {
            int totalLines = 0;
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), font);
                totalLines += wrapped.size();
            }
            Objects.requireNonNull(font);
            totalHeight = (float)(totalLines * 9) * scale;
            scale -= granularity;
        } while (totalHeight > (float)height);
        BookDataManager.Client.get().putScale(text, width, height, scale);
        return scale;
    }

    public static void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, Font font, int x, int y, int width, int height) {
        if (text.hasComponent()) {
            for (FormattedCharSequence formattedcharsequence : font.split((FormattedText)text.getComponent(), width)) {
                guiGraphics.drawString(font, formattedcharsequence, x, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        } else if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            float scale = BookPageRenderer.getBookTextHolderScaleForRenderSize(text, font, width, height);
            guiGraphics.pose().pushPose();
            if (scale < 1.0f) {
                guiGraphics.pose().translate((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.pose().scale(scale, scale, scale);
            }
            float renderY = y;
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    GuiGraphicsExt.drawString(guiGraphics, font, formattedcharsequence, (float)x, renderY, 0, false);
                    Objects.requireNonNull(font);
                    renderY += 9.0f;
                }
            }
            guiGraphics.pose().popPose();
        } else {
            Modonomicon.LOG.warn("BookTextHolder with String {} has no component, but is not rendered to markdown either.", (Object)text.getString());
        }
    }

    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        this.parentScreen = parentScreen;
        this.mc = Minecraft.getInstance();
        this.font = this.mc.font;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<Button>();
    }

    public T getPage() {
        return this.page;
    }

    public void onEndDisplayPage(BookEntryScreen parentScreen) {
        parentScreen.removeRenderableWidgets(this.buttons);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    @Deprecated
    public void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, int x, int y, int width) {
        int textY = 0;
        BookPageRenderer bookPageRenderer = this;
        if (bookPageRenderer instanceof PageWithTextRenderer) {
            PageWithTextRenderer pageWithTextRenderer = (PageWithTextRenderer)((Object)bookPageRenderer);
            textY = pageWithTextRenderer.getTextY();
        }
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x, y, width, 155 - textY);
    }

    public void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, int x, int y, int width, int height) {
        height += this.parentScreen.getBook().getBookTextOffsetHeight();
        width += this.parentScreen.getBook().getBookTextOffsetWidth();
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x += this.parentScreen.getBook().getBookTextOffsetX(), y += this.parentScreen.getBook().getBookTextOffsetY(), width -= this.parentScreen.getBook().getBookTextOffsetX(), height -= this.parentScreen.getBook().getBookTextOffsetY());
    }

    public void renderTitle(GuiGraphics guiGraphics, BookTextHolder title, boolean showTitleSeparator, int x, int y) {
        guiGraphics.pose().pushPose();
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.fromList(renderedTitle.getRenderedText().stream().map(Component::getVisualOrderText).toList());
            float scale = Math.min(1.0f, 120.0f / (float)this.font.width(formattedCharSequence));
            if (scale < 1.0f) {
                guiGraphics.pose().translate(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.pose().scale(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, formattedCharSequence, x, y, 0, scale);
        } else if (title.hasComponent()) {
            ResourceLocation font = BookDataManager.Client.get().safeFont(((BookPage)this.page).getBook().getFont());
            MutableComponent titleComponent = Component.empty().append(title.getComponent()).withStyle(s -> s.withFont(font));
            float scale = Math.min(1.0f, 120.0f / (float)this.font.width(titleComponent.getVisualOrderText()));
            if (scale < 1.0f) {
                guiGraphics.pose().translate(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.pose().scale(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, titleComponent.getVisualOrderText(), x, y, 0, scale);
        } else {
            BookErrorManager.get().setTo((BookPage)this.page);
            BookErrorManager.get().error("Non-markdown title has no component.");
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(null);
        }
        guiGraphics.pose().popPose();
        if (showTitleSeparator) {
            BookContentRenderer.drawTitleSeparator(guiGraphics, ((BookPage)this.page).getBook(), x, y + 12);
        }
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, FormattedCharSequence s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, String s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawWrappedStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, int width) {
        for (FormattedCharSequence formattedcharsequence : this.font.split((FormattedText)s, width)) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, formattedcharsequence, x, y + 9, color, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return null;
    }

    protected void addButton(Button button) {
        button.setX(button.getX() + this.parentScreen.getBookLeft() + this.left);
        button.setY(button.getY() + this.parentScreen.getBookTop() + this.top);
        this.buttons.add(button);
        this.parentScreen.addRenderableWidget(button);
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTitle(BookTextHolder title, int x, int y, double pMouseX, double pMouseY) {
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.fromList(renderedTitle.getRenderedText().stream().map(Component::getVisualOrderText).toList());
            if (pMouseY > (double)y) {
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(y + 9)) {
                    if (pMouseX < (double)(x -= this.font.width(formattedCharSequence) / 2)) {
                        return null;
                    }
                    return this.font.getSplitter().componentStyleAtWidth(formattedCharSequence, (int)pMouseX - x);
                }
            }
        } else if (pMouseY > (double)y) {
            Objects.requireNonNull(this.font);
            if (pMouseY < (double)(y + 9)) {
                FormattedCharSequence formattedCharSequence = title.getComponent().getVisualOrderText();
                if (pMouseX < (double)(x -= this.font.width(formattedCharSequence) / 2)) {
                    return null;
                }
                return this.font.getSplitter().componentStyleAtWidth(formattedCharSequence, (int)pMouseX - x);
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    protected Style getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, double pMouseX, double pMouseY) {
        int textY = 0;
        BookPageRenderer bookPageRenderer = this;
        if (bookPageRenderer instanceof PageWithTextRenderer) {
            PageWithTextRenderer pageWithTextRenderer = (PageWithTextRenderer)((Object)bookPageRenderer);
            textY = pageWithTextRenderer.getTextY();
        }
        return this.getClickedComponentStyleAtForTextHolder(text, x, y, width, 155 - textY, pMouseX, pMouseY);
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, int height, double pMouseX, double pMouseY) {
        block7: {
            block6: {
                if (!text.hasComponent()) break block6;
                for (FormattedCharSequence formattedcharsequence : this.font.split((FormattedText)text.getComponent(), width)) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.getSplitter().componentStyleAtWidth(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
                break block7;
            }
            if (!(text instanceof RenderedBookTextHolder)) break block7;
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            float scale = BookPageRenderer.getBookTextHolderScaleForRenderSize(text, this.font, width, height);
            float currentY = y;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), this.font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    float minY = currentY;
                    Objects.requireNonNull(this.font);
                    float maxY = currentY + 9.0f * scale;
                    if (pMouseY > (double)minY && pMouseY < (double)maxY) {
                        return this.font.getSplitter().componentStyleAtWidth(formattedcharsequence, (int)((pMouseX - (double)x) / (double)scale));
                    }
                    Objects.requireNonNull(this.font);
                    currentY += 9.0f * scale;
                }
            }
        }
        return null;
    }
}

