/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.search;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class BookSearchScreen
extends BookPaginatedScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    protected final BookParentScreen parentScreen;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookEntry> allEntries;
    private EditBox searchField;
    private BookTextHolder infoText;
    private List<Component> tooltip;

    public BookSearchScreen(BookParentScreen parentScreen) {
        super((Component)Component.translatable((String)"modonomicon.gui.search.screen.title"));
        this.parentScreen = parentScreen;
        this.infoText = new BookTextHolder("modonomicon.gui.search.info");
    }

    public void handleButtonEntry(Button button) {
        BookEntry entry = ((EntryListButton)button).getEntry();
        this.onClose();
        BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width((FormattedText)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookParentScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(this.font, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createSearchBar() {
        this.searchField = new EditBox(this.font, 160, 170, 90, 12, (Component)Component.literal((String)""));
        this.searchField.setMaxLength(32);
        this.searchField.setCanLoseFocus(false);
        this.searchField.setFocused(true);
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.renderables.remove(b);
            this.children().remove(b);
            this.narratables.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.getValue().toLowerCase();
        this.allEntries.stream().filter(e -> e.matchesQuery(query)).forEach(this.visibleEntries::add);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private List<BookEntry> getEntries() {
        return this.parentScreen.getBook().getEntries().values().stream().toList();
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -1300.0f);
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(guiGraphics, this.getTitle(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.search.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(guiGraphics, this.infoText, this.font, 12, 37, 124, 118);
        }
        if (!this.searchField.getValue().isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BookContentRenderer.drawFromContentTexture(guiGraphics, this.parentScreen.getBook(), this.searchField.getX() - 8, this.searchField.getY(), 140, 183, 99, 14);
            MutableComponent searchComponent = Component.literal((String)this.searchField.getValue());
            guiGraphics.drawString(this.font, (Component)searchComponent, this.searchField.getX() + 7, this.searchField.getY() + 1, 0, false);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.getValue().isEmpty()) {
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
                guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.search.sad"), 101, 47, 0x999999);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
            }
        }
        guiGraphics.pose().popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void onClose() {
        ClientServices.GUI.popGuiLayer();
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.getValue();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                BookEntry entry = this.visibleEntries.get(0);
                BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
                return true;
            }
        } else if (this.searchField.keyPressed(key, scanCode, modifiers)) {
            if (!this.searchField.getValue().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    public void init() {
        super.init();
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook(), (HolderLookup.Provider)this.minecraft.level.registryAccess());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, e.getCategory()) && BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, (BookEntry)e)).sorted(Comparator.comparing(a -> I18n.get((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createSearchBar();
        this.createEntryList();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return this.searchField.mouseClicked(pMouseX - (double)this.bookLeft, pMouseY - (double)this.bookTop, pButton) || super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean charTyped(char c, int i) {
        String currQuery = this.searchField.getValue();
        if (this.searchField.charTyped(c, i)) {
            if (!this.searchField.getValue().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.charTyped(c, i);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            EntryListButton button = new EntryListButton(this.visibleEntries.get(start + i), this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.addRenderableWidget((GuiEventListener)button);
            this.entryButtons.add(button);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

