/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ColorLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.CommandLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.PatchouliLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentStrikethroughExtension;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentUnderlineExtension;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;

public class BookTextRenderer {
    private final Parser markdownParser;
    private final List<Extension> extensions = List.of(ComponentStrikethroughExtension.create(), ComponentUnderlineExtension.create());
    private final Book book;
    private final HolderLookup.Provider provider;

    public BookTextRenderer(Book book, HolderLookup.Provider provider) {
        this.markdownParser = Parser.builder().extensions(this.extensions).build();
        this.book = book;
        this.provider = provider;
    }

    public List<MutableComponent> render(String markdown) {
        return this.render(markdown, Style.EMPTY);
    }

    public List<MutableComponent> render(String markdown, Style defaultStyle) {
        ComponentRenderer renderer = new ComponentRenderer.Builder().renderSoftLineBreaks(false).replaceSoftLineBreaksWithSpace(true).linkColor(TextColor.fromRgb((int)0x5555FF)).linkRenderers(List.of(new ColorLinkRenderer(), new BookLinkRenderer(), new ItemLinkRenderer(), new PatchouliLinkRenderer(), new CommandLinkRenderer())).style(defaultStyle.withFont(BookDataManager.Client.get().safeFont(this.book.getFont()))).extensions(this.extensions).build();
        Node document = this.markdownParser.parse(markdown);
        return renderer.render(document, this.book, this.provider);
    }
}

