/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class BookSpotlightPage
extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected Ingredient item;

    public BookSpotlightPage(BookTextHolder title, BookTextHolder text, Ingredient item, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.item = item;
    }

    public static BookSpotlightPage fromJson(JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY, provider);
        Ingredient item = (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("item")).result().get();
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new BookSpotlightPage(title, text, item, anchor, condition);
    }

    public static BookSpotlightPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        Ingredient item = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookSpotlightPage(title, text, item, anchor, condition);
    }

    public Ingredient getItem() {
        return this.item;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.SPOTLIGHT;
    }

    @Override
    public void build(Level level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (this.title.isEmpty()) {
            this.title = new BookTextHolder((Component)((MutableComponent)this.item.getItems()[0].getHoverName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((Component)Component.translatable((String)this.title.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        this.title.toNetwork(buffer);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)this.item);
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || Arrays.stream(this.item.getItems()).anyMatch(i -> I18n.get((String)i.getDescriptionId(), (Object[])new Object[0]).toLowerCase().contains(query)) || this.text.getString().toLowerCase().contains(query);
    }
}

