/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BookMultiblockPage
extends BookPage {
    protected BookTextHolder multiblockName;
    protected BookTextHolder text;
    protected boolean showVisualizeButton;
    protected ResourceLocation multiblockId;
    protected Multiblock multiblock;

    public BookMultiblockPage(BookTextHolder multiblockName, BookTextHolder text, ResourceLocation multiblockId, boolean showVisualizeButton, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.multiblockName = multiblockName;
        this.text = text;
        this.multiblockId = multiblockId;
        this.showVisualizeButton = showVisualizeButton;
    }

    public static BookMultiblockPage fromJson(JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder multiblockName = BookGsonHelper.getAsBookTextHolder(json, "multiblock_name", BookTextHolder.EMPTY, provider);
        ResourceLocation multiblockId = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"multiblock_id"));
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        boolean showVisualizeButton = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_visualize_button", (boolean)true);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor, condition);
    }

    public static BookMultiblockPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder multiblockName = BookTextHolder.fromNetwork(buffer);
        ResourceLocation multiblockId = buffer.readResourceLocation();
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        boolean showVisualizeButton = buffer.readBoolean();
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor, condition);
    }

    public boolean showVisualizeButton() {
        return this.showVisualizeButton;
    }

    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    public BookTextHolder getMultiblockName() {
        return this.multiblockName;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.MULTIBLOCK;
    }

    @Override
    public void build(Level level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        this.multiblock = MultiblockDataManager.get().getMultiblock(this.multiblockId);
        if (this.multiblock == null) {
            throw new IllegalArgumentException("Invalid multiblock id " + String.valueOf(this.multiblockId));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.multiblockName.hasComponent()) {
            this.multiblockName = new BookTextHolder((Component)Component.translatable((String)this.multiblockName.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        this.multiblockName.toNetwork(buffer);
        buffer.writeResourceLocation(this.multiblockId);
        this.text.toNetwork(buffer);
        buffer.writeBoolean(this.showVisualizeButton);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.multiblockName.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

