/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class EntryLinkBookEntry
extends BookEntry {
    protected ResourceLocation entryToOpenId;
    protected BookEntry entryToOpen;

    public EntryLinkBookEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, ResourceLocation entryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.entryToOpenId = entryToOpenId;
    }

    public static EntryLinkBookEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions, HolderLookup.Provider provider) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(json, autoAddReadConditions, provider);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        ResourceLocation entryToOpenId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"entry_to_open"));
        return new EntryLinkBookEntry(id, data, commandToRunOnFirstReadId, entryToOpenId);
    }

    public static EntryLinkBookEntry fromNetwork(RegistryFriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        ResourceLocation entryToOpen = buffer.readResourceLocation();
        return new EntryLinkBookEntry(id, data, commandToRunOnFirstReadId, entryToOpen);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.EntryType.ENTRY_LINK;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        this.data.toNetwork(buffer);
        buffer.writeNullable((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::writeResourceLocation);
        buffer.writeResourceLocation(this.entryToOpenId);
    }

    @Override
    public void build(Level level, BookCategory entry) {
        super.build(level, entry);
        if (this.entryToOpenId != null) {
            this.entryToOpen = this.getBook().getEntry(this.entryToOpenId);
            if (this.entryToOpen == null) {
                BookErrorManager.get().error("Entry to open \"" + String.valueOf(this.entryToOpenId) + "\" does not exist in this book. Set to null.");
                this.entryToOpenId = null;
            }
        }
    }

    public BookEntry getEntryToOpen() {
        return this.entryToOpen;
    }

    @Override
    public void openEntry(BookAddress address) {
        BookGuiManager.get().openEntry(this.entryToOpen, BookAddress.defaultFor(this.entryToOpen));
    }
}

