/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public abstract class BookCondition {
    protected Component tooltip;

    public BookCondition(Component tooltip) {
        this.tooltip = tooltip;
    }

    public static MutableComponent tooltipFromJson(JsonObject json, HolderLookup.Provider provider) {
        if (json.has("tooltip")) {
            JsonElement tooltipElement = json.get("tooltip");
            if (tooltipElement.isJsonPrimitive()) {
                return Component.translatable((String)tooltipElement.getAsString());
            }
            return Component.Serializer.fromJson((JsonElement)tooltipElement, (HolderLookup.Provider)provider);
        }
        return null;
    }

    public static BookCondition fromJson(JsonObject json, HolderLookup.Provider provider) {
        ResourceLocation type = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"type"));
        JsonLoader<? extends BookCondition> loader = LoaderRegistry.getConditionJsonLoader(type);
        return loader.fromJson(json, provider);
    }

    public static BookCondition fromNetwork(RegistryFriendlyByteBuf buf) {
        ResourceLocation type = buf.readResourceLocation();
        NetworkLoader<? extends BookCondition> loader = LoaderRegistry.getConditionNetworkLoader(type);
        return loader.fromNetwork(buf);
    }

    public static void toNetwork(BookCondition condition, RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(condition.getType());
        condition.toNetwork(buf);
    }

    public abstract ResourceLocation getType();

    public abstract void toNetwork(RegistryFriendlyByteBuf var1);

    public abstract boolean test(BookConditionContext var1, Player var2);

    public boolean testOnLoad() {
        return true;
    }

    public boolean requiresMultiPassUnlockTest() {
        return false;
    }

    public List<Component> getTooltip(Player player, BookConditionContext context) {
        return this.tooltip != null ? List.of(this.tooltip) : List.of();
    }
}

