/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookCategoryHasEntriesCondition
extends BookCondition {
    protected ResourceLocation categoryId;

    public BookCategoryHasEntriesCondition(Component tooltip, ResourceLocation categoryId) {
        super(tooltip);
        this.categoryId = categoryId;
    }

    public static BookCategoryHasEntriesCondition fromJson(JsonObject json, HolderLookup.Provider provider) {
        ResourceLocation categoryId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"category_id"));
        MutableComponent tooltip = Component.translatable((String)"tooltip.modonomicon.condition.has_entries", (Object[])new Object[]{categoryId});
        return new BookCategoryHasEntriesCondition((Component)tooltip, categoryId);
    }

    public static BookCategoryHasEntriesCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        ResourceLocation entryId = buffer.readResourceLocation();
        return new BookCategoryHasEntriesCondition(tooltip, entryId);
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeResourceLocation(this.categoryId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.CATEGORY_HAS_ENTRIES;
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        BookCategory category = context.book.getCategory(this.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Category with id " + String.valueOf(this.categoryId) + " not found in book " + String.valueOf(context.getBook().getId()) + "for BookCategoryHasEntriesCondition. This happened while trying to unlock " + String.valueOf(context));
        }
        return category.getEntries().size() > 0;
    }

    @Override
    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = Component.translatable((String)"tooltip.modonomicon.condition.entry_read", (Object[])new Object[]{Component.translatable((String)entryContext.getBook().getEntry(this.categoryId).getName())});
        }
        return super.getTooltip(player, context);
    }
}

