/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BookCategory {
    protected ResourceLocation id;
    protected Book book;
    protected String name;
    protected BookIcon icon;
    protected BookTextHolder description;
    protected BookDisplayMode displayMode;
    protected int sortNumber;
    protected ResourceLocation background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected int maxScrollX;
    protected int maxScrollY;
    protected float backgroundTextureZoomMultiplier;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers;
    protected ResourceLocation entryTextures;
    protected Map<ResourceLocation, BookEntry> entries;
    protected BookCondition condition;
    protected boolean showCategoryButton;
    protected ResourceLocation entryToOpen;
    protected boolean openEntryToOpenOnlyOnce;

    public BookCategory(ResourceLocation id, String name, BookTextHolder description, int sortNumber, BookCondition condition, boolean showCategoryButton, BookIcon icon, BookDisplayMode displayMode, ResourceLocation background, int backgroundWidth, int backgroundHeight, int maxScrollX, int maxScrollY, float backgroundTextureZoomMultiplier, List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers, ResourceLocation entryTextures, ResourceLocation entryToOpen, boolean openEntryOnlyOnce) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.sortNumber = sortNumber;
        this.condition = condition;
        this.showCategoryButton = showCategoryButton;
        this.icon = icon;
        this.displayMode = displayMode;
        this.background = background;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        this.maxScrollX = maxScrollX;
        this.maxScrollY = maxScrollY;
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        this.backgroundParallaxLayers = backgroundParallaxLayers;
        this.entryTextures = entryTextures;
        this.entries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.entryToOpen = entryToOpen;
        this.openEntryToOpenOnlyOnce = openEntryOnlyOnce;
    }

    public static BookCategory fromJson(ResourceLocation id, JsonObject json, HolderLookup.Provider provider) {
        String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
        BookTextHolder description = BookGsonHelper.getAsBookTextHolder(json, "description", BookTextHolder.EMPTY, provider);
        int sortNumber = GsonHelper.getAsInt((JsonObject)json, (String)"sort_number", (int)-1);
        BookIcon icon = BookIcon.fromJson(json.get("icon"));
        BookDisplayMode displayMode = BookDisplayMode.byName(GsonHelper.getAsString((JsonObject)json, (String)"display_mode", (String)BookDisplayMode.NODE.getSerializedName()));
        ResourceLocation background = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"background", (String)ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND));
        int backgroundWidth = GsonHelper.getAsInt((JsonObject)json, (String)"background_width", (int)512);
        int backgroundHeight = GsonHelper.getAsInt((JsonObject)json, (String)"background_height", (int)512);
        int defaultMaxScrollX = GsonHelper.getAsInt((JsonObject)json, (String)"max_scroll_x", (int)512);
        int defaultMaxScrollY = GsonHelper.getAsInt((JsonObject)json, (String)"max_scroll_y", (int)512);
        float backgroundTextureZoomMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"background_texture_zoom_multiplier", (float)1.0f);
        ResourceLocation entryTextures = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"entry_textures", (String)ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES));
        boolean showCategoryButton = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_category_button", (boolean)true);
        BookCondition condition = new BookNoneCondition();
        if (json.has("condition")) {
            condition = BookCondition.fromJson(json.getAsJsonObject("condition"), provider);
        }
        List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = List.of();
        if (json.has("background_parallax_layers")) {
            backgroundParallaxLayers = BookCategoryBackgroundParallaxLayer.fromJson(json.getAsJsonArray("background_parallax_layers"));
        }
        ResourceLocation entryToOpen = null;
        if (json.has("entry_to_open")) {
            entryToOpen = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"entry_to_open"));
        }
        boolean openEntryOnlyOnce = GsonHelper.getAsBoolean((JsonObject)json, (String)"open_entry_to_open_only_once", (boolean)true);
        return new BookCategory(id, name, description, sortNumber, condition, showCategoryButton, icon, displayMode, background, backgroundWidth, backgroundHeight, defaultMaxScrollX, defaultMaxScrollY, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures, entryToOpen, openEntryOnlyOnce);
    }

    public static BookCategory fromNetwork(ResourceLocation id, RegistryFriendlyByteBuf buffer) {
        String name = buffer.readUtf();
        BookTextHolder description = BookTextHolder.fromNetwork(buffer);
        int sortNumber = buffer.readInt();
        BookIcon icon = BookIcon.fromNetwork((FriendlyByteBuf)buffer);
        BookDisplayMode displayMode = BookDisplayMode.byId(buffer.readByte());
        ResourceLocation background = buffer.readResourceLocation();
        int backgroundWidth = buffer.readVarInt();
        int backgroundHeight = buffer.readVarInt();
        int defaultMaxScrollX = buffer.readVarInt();
        int defaultMaxScrollY = buffer.readVarInt();
        float backgroundTextureZoomMultiplier = buffer.readFloat();
        List backgroundParallaxLayers = buffer.readList(BookCategoryBackgroundParallaxLayer::fromNetwork);
        ResourceLocation entryTextures = buffer.readResourceLocation();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        boolean showCategoryButton = buffer.readBoolean();
        ResourceLocation entryToOpen = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        boolean openEntryOnlyOnce = buffer.readBoolean();
        return new BookCategory(id, name, description, sortNumber, condition, showCategoryButton, icon, displayMode, background, backgroundWidth, backgroundHeight, defaultMaxScrollX, defaultMaxScrollY, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures, entryToOpen, openEntryOnlyOnce);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        this.description.toNetwork(buffer);
        buffer.writeInt(this.sortNumber);
        this.icon.toNetwork((FriendlyByteBuf)buffer);
        buffer.writeByte(this.displayMode.ordinal());
        buffer.writeResourceLocation(this.background);
        buffer.writeVarInt(this.backgroundWidth);
        buffer.writeVarInt(this.backgroundHeight);
        buffer.writeVarInt(this.maxScrollX);
        buffer.writeVarInt(this.maxScrollY);
        buffer.writeFloat(this.backgroundTextureZoomMultiplier);
        buffer.writeCollection(this.backgroundParallaxLayers, (buf, layer) -> layer.toNetwork((FriendlyByteBuf)buf));
        buffer.writeResourceLocation(this.entryTextures);
        BookCondition.toNetwork(this.condition, buffer);
        buffer.writeBoolean(this.showCategoryButton);
        buffer.writeNullable((Object)this.entryToOpen, FriendlyByteBuf::writeResourceLocation);
        buffer.writeBoolean(this.openEntryToOpenOnlyOnce);
    }

    public void build(Level level, Book book) {
        BookEntry entry;
        this.book = book;
        for (BookEntry entry2 : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry2.getId();
            entry2.build(level, this);
            BookErrorManager.get().getContextHelper().entryId = null;
        }
        if (this.entryToOpen != null && (entry = this.entries.get(this.entryToOpen)) == null) {
            BookErrorManager.get().error(MessageFormat.format("EntryToOpen \"{0}\" in Category \"{1}\" does not exist.", this.entryToOpen, this.getId()));
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.description.hasComponent()) {
            this.description = new RenderedBookTextHolder(this.description, textRenderer.render(this.description.getString()));
        }
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            try {
                entry.prerenderMarkdown(textRenderer);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to render markdown in book '" + String.valueOf(this.book.getId()) + "' for entry '" + String.valueOf(entry.getId()) + "'", e);
            }
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolder getDescription() {
        return this.description;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public BookDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public float getBackgroundTextureZoomMultiplier() {
        return this.backgroundTextureZoomMultiplier;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public ResourceLocation getEntryTextures() {
        return this.entryTextures;
    }

    public Map<ResourceLocation, BookEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(ResourceLocation id) {
        return this.entries.get(id);
    }

    public BookCondition getCondition() {
        return this.condition;
    }

    public boolean openEntryToOpenOnlyOnce() {
        return this.openEntryToOpenOnlyOnce;
    }

    public ResourceLocation getEntryToOpen() {
        return this.entryToOpen;
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }
}

