/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.PageDisplayMode;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Book {
    protected ResourceLocation id;
    protected String name;
    protected BookTextHolder description;
    protected String tooltip;
    protected String creativeTab;
    protected ResourceLocation model;
    protected ResourceLocation bookOverviewTexture;
    protected ResourceLocation frameTexture;
    protected BookFrameOverlay topFrameOverlay;
    protected BookFrameOverlay bottomFrameOverlay;
    protected BookFrameOverlay leftFrameOverlay;
    protected BookFrameOverlay rightFrameOverlay;
    protected ResourceLocation bookContentTexture;
    protected ResourceLocation craftingTexture;
    protected ResourceLocation turnPageSound;
    protected Map<ResourceLocation, BookCategory> categories;
    protected Map<ResourceLocation, BookEntry> entries;
    protected Map<ResourceLocation, BookCommand> commands;
    protected int defaultTitleColor;
    protected float categoryButtonIconScale;
    protected boolean autoAddReadConditions;
    protected boolean generateBookItem;
    @Nullable
    protected ResourceLocation customBookItem;
    protected ResourceLocation font;
    protected BookDisplayMode displayMode;
    protected int bookTextOffsetX;
    protected int bookTextOffsetY;
    protected int bookTextOffsetWidth;
    protected int bookTextOffsetHeight;
    protected int categoryButtonXOffset;
    protected int categoryButtonYOffset;
    protected int searchButtonXOffset;
    protected int searchButtonYOffset;
    protected int readAllButtonYOffset;
    protected ResourceLocation leafletEntry;
    protected PageDisplayMode pageDisplayMode = PageDisplayMode.DOUBLE_PAGE;
    protected ResourceLocation singlePageTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_SINGLE_PAGE_TEXTURE);

    public Book(ResourceLocation id, String name, BookTextHolder description, String tooltip, ResourceLocation model, BookDisplayMode displayMode, boolean generateBookItem, @Nullable ResourceLocation customBookItem, String creativeTab, ResourceLocation font, ResourceLocation bookOverviewTexture, ResourceLocation frameTexture, BookFrameOverlay topFrameOverlay, BookFrameOverlay bottomFrameOverlay, BookFrameOverlay leftFrameOverlay, BookFrameOverlay rightFrameOverlay, ResourceLocation bookContentTexture, ResourceLocation craftingTexture, ResourceLocation turnPageSound, int defaultTitleColor, float categoryButtonIconScale, boolean autoAddReadConditions, int bookTextOffsetX, int bookTextOffsetY, int bookTextOffsetWidth, int bookTextOffsetHeight, int categoryButtonXOffset, int categoryButtonYOffset, int searchButtonXOffset, int searchButtonYOffset, int readAllButtonYOffset, ResourceLocation leafletEntry, PageDisplayMode pageDisplayMode, ResourceLocation singlePageTexture) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.tooltip = tooltip;
        this.model = model;
        this.displayMode = displayMode;
        this.generateBookItem = generateBookItem;
        this.customBookItem = customBookItem;
        this.creativeTab = creativeTab;
        this.bookOverviewTexture = bookOverviewTexture;
        this.font = font;
        this.frameTexture = frameTexture;
        this.topFrameOverlay = topFrameOverlay;
        this.bottomFrameOverlay = bottomFrameOverlay;
        this.leftFrameOverlay = leftFrameOverlay;
        this.rightFrameOverlay = rightFrameOverlay;
        this.bookContentTexture = bookContentTexture;
        this.craftingTexture = craftingTexture;
        this.turnPageSound = turnPageSound;
        this.defaultTitleColor = defaultTitleColor;
        this.categoryButtonIconScale = categoryButtonIconScale;
        this.autoAddReadConditions = autoAddReadConditions;
        this.categories = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.entries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.commands = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.bookTextOffsetX = bookTextOffsetX;
        this.bookTextOffsetY = bookTextOffsetY;
        this.bookTextOffsetWidth = bookTextOffsetWidth;
        this.bookTextOffsetHeight = bookTextOffsetHeight;
        this.categoryButtonXOffset = categoryButtonXOffset;
        this.categoryButtonYOffset = categoryButtonYOffset;
        this.searchButtonXOffset = searchButtonXOffset;
        this.searchButtonYOffset = searchButtonYOffset;
        this.readAllButtonYOffset = readAllButtonYOffset;
        this.leafletEntry = leafletEntry;
        this.pageDisplayMode = pageDisplayMode;
        this.singlePageTexture = singlePageTexture;
    }

    public static Book fromJson(ResourceLocation id, JsonObject json, HolderLookup.Provider provider) {
        String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
        BookTextHolder description = BookGsonHelper.getAsBookTextHolder(json, "description", BookTextHolder.EMPTY, provider);
        String tooltip = GsonHelper.getAsString((JsonObject)json, (String)"tooltip", (String)"");
        ResourceLocation model = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"model", (String)ModonomiconConstants.Data.Book.DEFAULT_MODEL));
        boolean generateBookItem = GsonHelper.getAsBoolean((JsonObject)json, (String)"generate_book_item", (boolean)true);
        BookDisplayMode displayMode = BookDisplayMode.byName(GsonHelper.getAsString((JsonObject)json, (String)"display_mode", (String)BookDisplayMode.NODE.getSerializedName()));
        ResourceLocation customBookItem = json.has("custom_book_item") ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"custom_book_item")) : null;
        String creativeTab = GsonHelper.getAsString((JsonObject)json, (String)"creative_tab", (String)"misc");
        ResourceLocation bookOverviewTexture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"book_overview_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE));
        ResourceLocation frameTexture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"frame_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_FRAME_TEXTURE));
        BookFrameOverlay topFrameOverlay = json.has("top_frame_overlay") ? BookFrameOverlay.fromJson(json.get("top_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_TOP_FRAME_OVERLAY;
        BookFrameOverlay bottomFrameOverlay = json.has("bottom_frame_overlay") ? BookFrameOverlay.fromJson(json.get("bottom_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_BOTTOM_FRAME_OVERLAY;
        BookFrameOverlay leftFrameOverlay = json.has("left_frame_overlay") ? BookFrameOverlay.fromJson(json.get("left_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_LEFT_FRAME_OVERLAY;
        BookFrameOverlay rightFrameOverlay = json.has("right_frame_overlay") ? BookFrameOverlay.fromJson(json.get("right_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_RIGHT_FRAME_OVERLAY;
        ResourceLocation font = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"font", (String)ModonomiconConstants.Data.Book.DEFAULT_FONT));
        ResourceLocation bookContentTexture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"book_content_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE));
        ResourceLocation craftingTexture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"crafting_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE));
        ResourceLocation turnPageSound = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"turn_page_sound", (String)ModonomiconConstants.Data.Book.DEFAULT_PAGE_TURN_SOUND));
        int defaultTitleColor = GsonHelper.getAsInt((JsonObject)json, (String)"default_title_color", (int)0);
        float categoryButtonIconScale = GsonHelper.getAsFloat((JsonObject)json, (String)"category_button_icon_scale", (float)1.0f);
        boolean autoAddReadConditions = GsonHelper.getAsBoolean((JsonObject)json, (String)"auto_add_read_conditions", (boolean)false);
        int bookTextOffsetX = GsonHelper.getAsInt((JsonObject)json, (String)"book_text_offset_x", (int)0);
        int bookTextOffsetY = GsonHelper.getAsInt((JsonObject)json, (String)"book_text_offset_y", (int)0);
        int bookTextOffsetWidth = GsonHelper.getAsInt((JsonObject)json, (String)"book_text_offset_width", (int)0);
        int bookTextOffsetHeight = GsonHelper.getAsInt((JsonObject)json, (String)"book_text_offset_height", (int)0);
        int categoryButtonXOffset = GsonHelper.getAsInt((JsonObject)json, (String)"category_button_x_offset", (int)0);
        int categoryButtonYOffset = GsonHelper.getAsInt((JsonObject)json, (String)"category_button_y_offset", (int)0);
        int searchButtonXOffset = GsonHelper.getAsInt((JsonObject)json, (String)"search_button_x_offset", (int)0);
        int searchButtonYOffset = GsonHelper.getAsInt((JsonObject)json, (String)"search_button_y_offset", (int)0);
        int readAllButtonYOffset = GsonHelper.getAsInt((JsonObject)json, (String)"read_all_button_y_offset", (int)0);
        ResourceLocation leafletEntry = json.has("leaflet_entry") ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"leaflet_entry")) : null;
        PageDisplayMode pageDisplayMode = PageDisplayMode.byName(GsonHelper.getAsString((JsonObject)json, (String)"page_display_mode", (String)PageDisplayMode.DOUBLE_PAGE.getSerializedName()));
        ResourceLocation singlePageTexture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"single_page_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_SINGLE_PAGE_TEXTURE));
        return new Book(id, name, description, tooltip, model, displayMode, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, bookTextOffsetHeight, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, leafletEntry, pageDisplayMode, singlePageTexture);
    }

    public static Book fromNetwork(ResourceLocation id, RegistryFriendlyByteBuf buffer) {
        String name = buffer.readUtf();
        BookTextHolder description = BookTextHolder.fromNetwork(buffer);
        String tooltip = buffer.readUtf();
        ResourceLocation model = buffer.readResourceLocation();
        BookDisplayMode displayMode = BookDisplayMode.byId(buffer.readByte());
        boolean generateBookItem = buffer.readBoolean();
        ResourceLocation customBookItem = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        String creativeTab = buffer.readUtf();
        ResourceLocation font = buffer.readResourceLocation();
        ResourceLocation bookOverviewTexture = buffer.readResourceLocation();
        ResourceLocation frameTexture = buffer.readResourceLocation();
        BookFrameOverlay topFrameOverlay = BookFrameOverlay.fromNetwork((FriendlyByteBuf)buffer);
        BookFrameOverlay bottomFrameOverlay = BookFrameOverlay.fromNetwork((FriendlyByteBuf)buffer);
        BookFrameOverlay leftFrameOverlay = BookFrameOverlay.fromNetwork((FriendlyByteBuf)buffer);
        BookFrameOverlay rightFrameOverlay = BookFrameOverlay.fromNetwork((FriendlyByteBuf)buffer);
        ResourceLocation bookContentTexture = buffer.readResourceLocation();
        ResourceLocation craftingTexture = buffer.readResourceLocation();
        ResourceLocation turnPageSound = buffer.readResourceLocation();
        int defaultTitleColor = buffer.readInt();
        float categoryButtonIconScale = buffer.readFloat();
        boolean autoAddReadConditions = buffer.readBoolean();
        short bookTextOffsetX = buffer.readShort();
        short bookTextOffsetY = buffer.readShort();
        short bookTextOffsetWidth = buffer.readShort();
        short bookTextOffsetHeight = buffer.readShort();
        short categoryButtonXOffset = buffer.readShort();
        short categoryButtonYOffset = buffer.readShort();
        short searchButtonXOffset = buffer.readShort();
        short searchButtonYOffset = buffer.readShort();
        short readAllButtonYOffset = buffer.readShort();
        ResourceLocation leafletEntry = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        PageDisplayMode pageDisplayMode = PageDisplayMode.byId(buffer.readByte());
        ResourceLocation singlePageTexture = buffer.readResourceLocation();
        return new Book(id, name, description, tooltip, model, displayMode, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, bookTextOffsetHeight, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, leafletEntry, pageDisplayMode, singlePageTexture);
    }

    public void build(Level level) {
        for (BookCategory category : this.categories.values()) {
            for (BookEntry entry : category.getEntries().values()) {
                this.addEntry(entry);
            }
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.build(level, this);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
        for (BookCommand command : this.commands.values()) {
            command.build(this);
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.description.hasComponent()) {
            this.description = new RenderedBookTextHolder(this.description, textRenderer.render(this.description.getString()));
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        this.description.toNetwork(buffer);
        buffer.writeUtf(this.tooltip);
        buffer.writeResourceLocation(this.model);
        buffer.writeByte(this.displayMode.ordinal());
        buffer.writeBoolean(this.generateBookItem);
        buffer.writeNullable((Object)this.customBookItem, FriendlyByteBuf::writeResourceLocation);
        buffer.writeUtf(this.creativeTab);
        buffer.writeResourceLocation(this.font);
        buffer.writeResourceLocation(this.bookOverviewTexture);
        buffer.writeResourceLocation(this.frameTexture);
        this.topFrameOverlay.toNetwork((FriendlyByteBuf)buffer);
        this.bottomFrameOverlay.toNetwork((FriendlyByteBuf)buffer);
        this.leftFrameOverlay.toNetwork((FriendlyByteBuf)buffer);
        this.rightFrameOverlay.toNetwork((FriendlyByteBuf)buffer);
        buffer.writeResourceLocation(this.bookContentTexture);
        buffer.writeResourceLocation(this.craftingTexture);
        buffer.writeResourceLocation(this.turnPageSound);
        buffer.writeInt(this.defaultTitleColor);
        buffer.writeFloat(this.categoryButtonIconScale);
        buffer.writeBoolean(this.autoAddReadConditions);
        buffer.writeShort(this.bookTextOffsetX);
        buffer.writeShort(this.bookTextOffsetY);
        buffer.writeShort(this.bookTextOffsetWidth);
        buffer.writeShort(this.bookTextOffsetHeight);
        buffer.writeShort(this.categoryButtonXOffset);
        buffer.writeShort(this.categoryButtonYOffset);
        buffer.writeShort(this.searchButtonXOffset);
        buffer.writeShort(this.searchButtonYOffset);
        buffer.writeShort(this.readAllButtonYOffset);
        buffer.writeNullable((Object)this.leafletEntry, FriendlyByteBuf::writeResourceLocation);
        buffer.writeByte(this.pageDisplayMode.ordinal());
        buffer.writeResourceLocation(this.singlePageTexture);
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public ResourceLocation getTurnPageSound() {
        return this.turnPageSound;
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public float getCategoryButtonIconScale() {
        return this.categoryButtonIconScale;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void addCategory(BookCategory category) {
        this.categories.putIfAbsent(category.id, category);
    }

    public BookCategory getCategory(ResourceLocation id) {
        return this.categories.get(id);
    }

    public Map<ResourceLocation, BookCategory> getCategories() {
        return this.categories;
    }

    public List<BookCategory> getCategoriesSorted() {
        return this.categories.values().stream().sorted(Comparator.comparingInt(BookCategory::getSortNumber)).toList();
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(ResourceLocation id) {
        return this.entries.get(id);
    }

    public Map<ResourceLocation, BookEntry> getEntries() {
        return this.entries;
    }

    public void addCommand(BookCommand command) {
        this.commands.putIfAbsent(command.id, command);
    }

    public Map<ResourceLocation, BookCommand> getCommands() {
        return this.commands;
    }

    public BookCommand getCommand(ResourceLocation id) {
        return this.commands.get(id);
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolder getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public ResourceLocation getFont() {
        return this.font;
    }

    public ResourceLocation getFrameTexture() {
        return this.frameTexture;
    }

    public BookFrameOverlay getTopFrameOverlay() {
        return this.topFrameOverlay;
    }

    public BookFrameOverlay getBottomFrameOverlay() {
        return this.bottomFrameOverlay;
    }

    public BookFrameOverlay getLeftFrameOverlay() {
        return this.leftFrameOverlay;
    }

    public BookFrameOverlay getRightFrameOverlay() {
        return this.rightFrameOverlay;
    }

    @Nullable
    public ResourceLocation getCustomBookItem() {
        return this.customBookItem;
    }

    public ResourceLocation getCraftingTexture() {
        return this.craftingTexture;
    }

    public ResourceLocation getBookContentTexture() {
        return this.bookContentTexture;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public BookDisplayMode getDisplayMode() {
        if (this.isLeaflet()) {
            return BookDisplayMode.INDEX;
        }
        return this.displayMode;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }

    public int getBookTextOffsetX() {
        return this.bookTextOffsetX;
    }

    public int getBookTextOffsetY() {
        return this.bookTextOffsetY;
    }

    public int getBookTextOffsetWidth() {
        return this.bookTextOffsetWidth;
    }

    public int getBookTextOffsetHeight() {
        return this.bookTextOffsetHeight;
    }

    public int getCategoryButtonXOffset() {
        return this.categoryButtonXOffset;
    }

    public int getCategoryButtonYOffset() {
        return this.categoryButtonYOffset;
    }

    public int getSearchButtonXOffset() {
        return this.searchButtonXOffset;
    }

    public int getSearchButtonYOffset() {
        return this.searchButtonYOffset;
    }

    public int getReadAllButtonYOffset() {
        return this.readAllButtonYOffset;
    }

    public ResourceLocation getLeafletEntry() {
        return this.leafletEntry;
    }

    public boolean isLeaflet() {
        return this.leafletEntry != null;
    }

    public BookAddress getLeafletAddress() {
        BookEntry leafletEntry = this.getEntry(this.leafletEntry);
        return BookAddress.ignoreSaved(leafletEntry);
    }

    public PageDisplayMode getPageDisplayMode() {
        return this.pageDisplayMode;
    }

    public ResourceLocation getSinglePageTexture() {
        return this.singlePageTexture;
    }
}

