/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;

public abstract class SingleBookSubProvider
extends ModonomiconProviderBase
implements BookSubProvider {
    protected BookModel book = null;
    protected String bookId;
    protected int currentSortIndex;

    public SingleBookSubProvider(String bookId, String modId, BiConsumer<String, String> defaultLang) {
        this(bookId, modId, defaultLang, Map.of());
    }

    public SingleBookSubProvider(String bookId, String modId, BiConsumer<String, String> defaultLang, Map<String, BiConsumer<String, String>> translations) {
        super(modId, defaultLang, translations, new BookContextHelper(modId), new ConditionHelper());
        this.bookId = bookId;
        this.currentSortIndex = 0;
    }

    public String bookId() {
        return this.bookId;
    }

    protected void registerDefaultMacro(String macro, String value) {
        this.registerMacro(macro, value);
    }

    protected BookCategoryModel add(BookCategoryModel category) {
        if (category.getSortNumber() == -1) {
            category.withSortNumber(this.currentSortIndex++);
        }
        this.book.withCategory(category);
        return category;
    }

    @Override
    public void generate(BiConsumer<ResourceLocation, BookModel> consumer) {
        String bookDescription;
        this.registerDefaultMacros();
        this.context().book(this.bookId());
        BookModel book = BookModel.create(this.modLoc(this.bookId), this.context().bookName());
        this.add(this.context().bookName(), this.bookName());
        String bookTooltip = this.bookTooltip();
        if (!StringUtil.isNullOrEmpty((String)bookTooltip)) {
            this.add(this.context().bookTooltip(), bookTooltip);
            book.withTooltip(this.context().bookTooltip());
        }
        if (!StringUtil.isNullOrEmpty((String)(bookDescription = this.bookDescription()))) {
            this.add(this.context().bookDescription(), bookDescription);
            book.withDescription(this.context().bookDescription());
        }
        this.book = this.additionalSetup(book);
        this.generateCategories();
        consumer.accept(this.book.getId(), this.book);
    }

    protected abstract void registerDefaultMacros();

    protected abstract void generateCategories();

    protected BookModel additionalSetup(BookModel book) {
        return book;
    }

    protected abstract String bookName();

    protected abstract String bookTooltip();

    protected String bookDescription() {
        return "";
    }
}

