/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.QueryType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

public class EmiSearchWidget
extends EditBox {
    private static final Pattern ESCAPE = Pattern.compile("\\\\.");
    private List<String> searchHistory = Lists.newArrayList();
    private int searchHistoryIndex = 0;
    private List<Tuple<Integer, Style>> styles;
    private long lastClick = 0L;
    private String last = "";
    private long lastRender = System.currentTimeMillis();
    private long accumulatedSpin = 0L;
    public boolean highlight = false;
    public boolean isFocused;

    public EmiSearchWidget(Font textRenderer, int x, int y, int width, int height) {
        super(textRenderer, x, y, width, height, (Component)EmiPort.literal(""));
        this.setCanLoseFocus(true);
        this.setTextColor(-1);
        this.setTextColorUneditable(-1);
        this.setMaxLength(256);
        this.setFormatter((string, stringStart) -> {
            int end;
            Tuple<Integer, Style> style;
            int s;
            MutableComponent text = null;
            int last = 0;
            for (s = 0; s < this.styles.size(); ++s) {
                style = this.styles.get(s);
                end = (Integer)style.getA();
                if (end <= stringStart) continue;
                if (end - stringStart >= string.length()) {
                    text = EmiPort.literal(string.substring(0, string.length()), (Style)style.getB());
                    s = this.styles.size();
                    break;
                }
                text = EmiPort.literal(string.substring(0, end - stringStart), (Style)style.getB());
                last = end - stringStart;
                ++s;
                break;
            }
            while (s < this.styles.size()) {
                style = this.styles.get(s);
                end = (Integer)style.getA();
                if (end - stringStart >= string.length()) {
                    EmiPort.append(text, (Component)EmiPort.literal(string.substring(last, string.length()), (Style)style.getB()));
                    break;
                }
                EmiPort.append(text, (Component)EmiPort.literal(string.substring(last, end - stringStart), (Style)style.getB()));
                last = end - stringStart;
                ++s;
            }
            return EmiPort.ordered(text);
        });
        this.setResponder(string -> {
            if (string.isEmpty()) {
                this.setSuggestion(I18n.get((String)"emi.search", (Object[])new Object[0]));
                EmiScreenManager.focusSearchSidebarType(EmiConfig.emptySearchSidebarFocus);
            } else {
                this.setSuggestion("");
                EmiScreenManager.focusSearchSidebarType(EmiConfig.searchSidebarFocus);
            }
            Matcher matcher = EmiSearch.TOKENS.matcher((CharSequence)string);
            ArrayList styles = Lists.newArrayList();
            int last = 0;
            while (matcher.find()) {
                String group;
                int start = matcher.start();
                int end = matcher.end();
                if (last < start) {
                    styles.add(new Tuple((Object)start, (Object)Style.EMPTY.applyFormat(ChatFormatting.WHITE)));
                }
                if ((group = matcher.group()).startsWith("-")) {
                    styles.add(new Tuple((Object)(start + 1), (Object)Style.EMPTY.applyFormat(ChatFormatting.RED)));
                    ++start;
                    group = group.substring(1);
                }
                QueryType type = QueryType.fromString(group);
                int subStart = type.prefix.length();
                if (group.length() > 1 + subStart && group.substring(subStart).startsWith("/") && group.endsWith("/")) {
                    int rOff = start + subStart + 1;
                    styles.add(new Tuple((Object)rOff, (Object)type.slashColor));
                    Matcher rMatcher = ESCAPE.matcher(string.substring(rOff, end - 1));
                    int rLast = 0;
                    while (rMatcher.find()) {
                        int rStart = rMatcher.start();
                        int rEnd = rMatcher.end();
                        if (rLast < rStart) {
                            styles.add(new Tuple((Object)(rStart + rOff), (Object)type.regexColor));
                        }
                        styles.add(new Tuple((Object)(rEnd + rOff), (Object)type.escapeColor));
                        rLast = rEnd;
                    }
                    if (rLast < end - 1) {
                        styles.add(new Tuple((Object)(end - 1), (Object)type.regexColor));
                    }
                    styles.add(new Tuple((Object)end, (Object)type.slashColor));
                } else {
                    styles.add(new Tuple((Object)end, (Object)type.color));
                }
                last = end;
            }
            if (last < string.length()) {
                styles.add(new Tuple((Object)string.length(), (Object)Style.EMPTY.applyFormat(ChatFormatting.WHITE)));
            }
            this.styles = styles;
            EmiSearch.search(string);
        });
    }

    public void update() {
        this.setValue(this.getValue());
    }

    public void swap() {
        String last = this.getValue();
        this.setValue(this.last);
        this.last = last;
    }

    public void setFocused(boolean focused) {
        if (!focused) {
            this.searchHistoryIndex = 0;
            String currentSearch = this.getValue();
            if (!currentSearch.isBlank() && !currentSearch.isEmpty()) {
                this.searchHistory.removeIf(String::isBlank);
                this.searchHistory.remove(currentSearch);
                this.searchHistory.add(0, currentSearch);
                if (this.searchHistory.size() > 36) {
                    this.searchHistory.remove(this.searchHistory.size() - 1);
                }
            }
        }
        this.isFocused = focused;
        super.setFocused(focused);
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY) || !EmiConfig.enabled) {
            EmiPort.focus(this, false);
            return false;
        }
        boolean b = super.mouseClicked(mouseX, mouseY, button == 1 ? 0 : button);
        if (this.isMouseOver(mouseX, mouseY)) {
            EmiPort.focus(this, true);
        }
        if (this.isFocused()) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastClick < 500L) {
                    this.highlight = !this.highlight;
                    this.lastClick = 0L;
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            } else if (button == 1) {
                this.setValue("");
                EmiPort.focus(this, true);
            }
        }
        return b;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused()) {
            if (EmiConfig.clearSearch.matchesKey(keyCode, scanCode)) {
                this.setValue("");
                return true;
            }
            if (EmiConfig.focusSearch.matchesKey(keyCode, scanCode) || keyCode == 257 || keyCode == 256) {
                EmiPort.focus(this, false);
                return true;
            }
            if (keyCode == 265 || keyCode == 264) {
                int offset;
                int n = offset = keyCode == 265 ? 1 : -1;
                if (this.searchHistoryIndex + offset >= 0 && this.searchHistoryIndex + offset < this.searchHistory.size()) {
                    if (this.searchHistoryIndex >= 0 && this.searchHistoryIndex < this.searchHistory.size()) {
                        this.searchHistory.set(this.searchHistoryIndex, this.getValue());
                    }
                    this.searchHistoryIndex += offset;
                    this.setValue(this.searchHistory.get(this.searchHistoryIndex));
                }
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderWidget(GuiGraphics raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.setEditable(EmiConfig.enabled);
        String lower = this.getValue().toLowerCase();
        boolean dinnerbone = lower.contains("dinnerbone");
        this.accumulatedSpin += (long)(dinnerbone ? 1 : -1) * Math.abs(System.currentTimeMillis() - this.lastRender);
        if (this.accumulatedSpin < 0L) {
            this.accumulatedSpin = 0L;
        } else if (this.accumulatedSpin > 500L) {
            this.accumulatedSpin = 500L;
        }
        this.lastRender = System.currentTimeMillis();
        long deg = this.accumulatedSpin * -180L / 500L;
        Matrix4fStack view = RenderSystem.getModelViewStack();
        view.pushMatrix();
        if (deg != 0L) {
            view.translate((float)(this.x + this.width / 2), (float)(this.y + this.height / 2), 0.0f);
            view.rotate((Quaternionfc)Axis.ZN.rotationDegrees((float)deg));
            view.translate((float)(-(this.x + this.width / 2)), (float)(-(this.y + this.height / 2)), 0.0f);
            RenderSystem.applyModelViewMatrix();
        }
        if (lower.contains("jeb_")) {
            int amount = 1023;
            float h = (float)(this.lastRender & (long)amount) % (float)amount / (float)amount;
            int rgb = Mth.hsvToRgb((float)h, (float)1.0f, (float)1.0f);
            context.setColor((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
        }
        if (EmiConfig.enabled) {
            super.renderWidget(context.raw(), mouseX, mouseY, delta);
            if (this.highlight) {
                int border = -1118720;
                context.fill(this.x - 1, this.y - 1, this.width + 2, 1, border);
                context.fill(this.x - 1, this.y + this.height, this.width + 2, 1, border);
                context.fill(this.x - 1, this.y - 1, 1, this.height + 2, border);
                context.fill(this.x + this.width, this.y - 1, 1, this.height + 2, border);
            }
        }
        context.resetColor();
        view.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }
}

