/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CommandS2CPacket
implements EmiPacket {
    private final byte type;
    private final ResourceLocation id;

    public CommandS2CPacket(byte type, ResourceLocation id) {
        this.type = type;
        this.id = id;
    }

    public CommandS2CPacket(FriendlyByteBuf buf) {
        this.type = buf.readByte();
        this.id = this.type == 1 || this.type == 17 || this.type == 18 ? buf.readResourceLocation() : null;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeByte((int)this.type);
        if (this.type == 1 || this.type == 17 || this.type == 18) {
            buf.writeResourceLocation(this.id);
        }
    }

    @Override
    public void apply(Player player) {
        EmiRecipe recipe;
        if (this.type == 1) {
            EmiRecipe recipe2 = EmiApi.getRecipeManager().getRecipe(this.id);
            if (recipe2 != null) {
                EmiApi.displayRecipe(recipe2);
            }
        } else if (this.type == 2) {
            EmiApi.viewRecipeTree();
        } else if (this.type == 17) {
            EmiRecipe recipe3 = EmiApi.getRecipeManager().getRecipe(this.id);
            if (recipe3 != null) {
                BoM.setGoal(recipe3);
            }
        } else if (this.type == 18 && (recipe = EmiApi.getRecipeManager().getRecipe(this.id)) != null && BoM.tree != null) {
            for (EmiStack stack : recipe.getOutputs()) {
                BoM.tree.addResolution(stack, recipe);
            }
        }
    }

    public CustomPacketPayload.Type<CommandS2CPacket> type() {
        return EmiNetwork.COMMAND;
    }
}

