/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class EmiTagExclusionsLoader
extends SimplePreparableReloadListener<TagExclusions>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    private static final ResourceLocation ID = EmiPort.id("emi:tag_exclusions");

    public TagExclusions prepare(ResourceManager manager, ProfilerFiller profiler) {
        TagExclusions exclusions = new TagExclusions();
        for (ResourceLocation id : EmiPort.findResources(manager, "tag/exclusions", i -> i.endsWith(".json"))) {
            if (!id.getNamespace().equals("emi")) continue;
            try {
                for (Resource resource : manager.getResourceStack(id)) {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    try {
                        if (GsonHelper.getAsBoolean((JsonObject)json, (String)"replace", (boolean)false)) {
                            exclusions.clear();
                        }
                        for (String key : json.keySet()) {
                            ResourceLocation type = EmiPort.id(key);
                            if (!GsonHelper.isArrayNode((JsonObject)json, (String)key)) continue;
                            JsonArray arr = GsonHelper.getAsJsonArray((JsonObject)json, (String)key);
                            for (JsonElement el : arr) {
                                ResourceLocation eid = EmiPort.id(el.getAsString());
                                if (key.equals("exclusions")) {
                                    exclusions.add(eid);
                                    if (!eid.getNamespace().equals("c")) continue;
                                    exclusions.add(EmiPort.id("forge", eid.getPath()));
                                    continue;
                                }
                                exclusions.add(type, eid);
                                if (!eid.getNamespace().equals("c")) continue;
                                exclusions.add(type, EmiPort.id("forge", eid.getPath()));
                            }
                        }
                    }
                    catch (Exception e) {
                        EmiLog.error("Error loading tag exclusions");
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                EmiLog.error("Error loading tag exclusions");
                e.printStackTrace();
            }
        }
        return exclusions;
    }

    public void apply(TagExclusions exclusions, ResourceManager manager, ProfilerFiller profiler) {
        EmiTags.exclusions = exclusions;
    }

    @Override
    public ResourceLocation getEmiId() {
        return ID;
    }
}

