/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.mixin.accessor.DrawContextAccessor;
import dev.emi.emi.mixin.accessor.OrderedTextTooltipComponentAccessor;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class EmiRenderHelper {
    public static final DecimalFormat TEXT_FORMAT = new DecimalFormat("0.##");
    public static final Component EMPTY_TEXT = EmiPort.literal("");
    public static final Minecraft CLIENT = Minecraft.getInstance();
    public static final ResourceLocation WIDGETS = EmiPort.id("emi", "textures/gui/widgets.png");
    public static final ResourceLocation BUTTONS = EmiPort.id("emi", "textures/gui/buttons.png");
    public static final ResourceLocation BACKGROUND = EmiPort.id("emi", "textures/gui/background.png");
    public static final ResourceLocation GRID = EmiPort.id("emi", "textures/gui/grid.png");
    public static final ResourceLocation DASH = EmiPort.id("emi", "textures/gui/dash.png");
    public static final ResourceLocation CONFIG = EmiPort.id("emi", "textures/gui/config.png");
    public static final ResourceLocation PIECES = EmiPort.id("emi", "textures/gui/pieces.png");

    public static void drawNinePatch(EmiDrawContext context, ResourceLocation texture, int x, int y, int w, int h, int u, int v, int cornerLength, int centerLength) {
        int cor = cornerLength;
        int cen = centerLength;
        int corcen = cor + cen;
        int innerWidth = w - cornerLength * 2;
        int innerHeight = h - cornerLength * 2;
        int coriw = cor + innerWidth;
        int corih = cor + innerHeight;
        context.drawTexture(texture, x, y, cor, cor, u, v, cor, cor, 256, 256);
        context.drawTexture(texture, x + cor, y, innerWidth, cor, u + cor, v, cen, cor, 256, 256);
        context.drawTexture(texture, x + coriw, y, cor, cor, u + corcen, v, cor, cor, 256, 256);
        context.drawTexture(texture, x, y + cor, cor, innerHeight, u, v + cor, cor, cen, 256, 256);
        context.drawTexture(texture, x + cor, y + cor, innerWidth, innerHeight, u + cor, v + cor, cen, cen, 256, 256);
        context.drawTexture(texture, x + coriw, y + cor, cor, innerHeight, u + corcen, v + cor, cor, cen, 256, 256);
        context.drawTexture(texture, x, y + corih, cor, cor, u, v + corcen, cor, cor, 256, 256);
        context.drawTexture(texture, x + cor, y + corih, innerWidth, cor, u + cor, v + corcen, cen, cor, 256, 256);
        context.drawTexture(texture, x + coriw, y + corih, cor, cor, u + corcen, v + corcen, cor, cor, 256, 256);
    }

    public static void drawTintedSprite(PoseStack matrices, TextureAtlasSprite sprite, int color, int x, int y, int xOff, int yOff, int width, int height) {
        if (sprite == null) {
            return;
        }
        EmiPort.setPositionColorTexShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.enableBlend();
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float xMin = x;
        float yMin = y;
        float xMax = xMin + (float)width;
        float yMax = yMin + (float)height;
        float uSpan = sprite.getU1() - sprite.getU0();
        float vSpan = sprite.getV1() - sprite.getV0();
        float uMin = sprite.getU0() + uSpan / 16.0f * (float)xOff;
        float vMin = sprite.getV0() + vSpan / 16.0f * (float)yOff;
        float uMax = sprite.getU1() - uSpan / 16.0f * (float)(16 - (width + xOff));
        float vMax = sprite.getV1() - vSpan / 16.0f * (float)(16 - (height + yOff));
        Matrix4f model = matrices.last().pose();
        bufferBuilder.addVertex(model, xMin, yMax, 1.0f).setColor(r, g, b, 1.0f).setUv(uMin, vMax);
        bufferBuilder.addVertex(model, xMax, yMax, 1.0f).setColor(r, g, b, 1.0f).setUv(uMax, vMax);
        bufferBuilder.addVertex(model, xMax, yMin, 1.0f).setColor(r, g, b, 1.0f).setUv(uMax, vMin);
        bufferBuilder.addVertex(model, xMin, yMin, 1.0f).setColor(r, g, b, 1.0f).setUv(uMin, vMin);
        EmiPort.draw(bufferBuilder);
    }

    public static void drawScroll(EmiDrawContext context, int x, int y, int width, int height, int progress, int total, int color) {
        if (total <= 1) {
            return;
        }
        int start = x + width * progress / total;
        int end = start + Math.max(width / total, 1);
        if (progress == total - 1) {
            end = x + width;
            start = end - Math.max(width / total, 1);
        }
        context.fill(start, y, end - start, height, color);
    }

    public static Component getEmiText() {
        return EmiPort.append(EmiPort.append(EmiPort.literal("E", Style.EMPTY.withColor(15432700)), (Component)EmiPort.literal("M", Style.EMPTY.withColor(8125602))), (Component)EmiPort.literal("I", Style.EMPTY.withColor(8121340)));
    }

    public static Component getPageText(int page, int total, int maxWidth) {
        MutableComponent text = EmiPort.translatable("emi.page", page, total);
        if (EmiRenderHelper.CLIENT.font.width((FormattedText)text) > maxWidth && EmiRenderHelper.CLIENT.font.width((FormattedText)(text = EmiPort.translatable("emi.page.short", page, total))) > maxWidth && EmiRenderHelper.CLIENT.font.width((FormattedText)(text = EmiPort.literal("" + page))) > maxWidth) {
            text = EmiPort.literal("");
        }
        return text;
    }

    public static void drawLeftTooltip(Screen screen, EmiDrawContext context, List<ClientTooltipComponent> components, int x, int y) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, screen.width / 2 - 16, (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> {
            Vector2i pos = new Vector2i(mouseX, mouseY).add(12, -12);
            pos.x = Math.max(pos.x - 24 - tooltipWidth, 4);
            if (pos.y + tooltipHeight + 3 > screenHeight) {
                pos.y = screenHeight - tooltipHeight - 3;
            }
            return pos;
        });
    }

    public static void drawTooltip(Screen screen, EmiDrawContext context, List<ClientTooltipComponent> components, int x, int y) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, screen.width / 2 - 16);
    }

    public static void drawTooltip(Screen screen, EmiDrawContext context, List<ClientTooltipComponent> components, int x, int y, int maxWidth) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, maxWidth, DefaultTooltipPositioner.INSTANCE);
    }

    public static void drawTooltip(Screen screen, EmiDrawContext context, List<ClientTooltipComponent> components, int x, int y, int maxWidth, ClientTooltipPositioner positioner) {
        y = Math.max(16, y);
        ArrayList mutable = Lists.newArrayList();
        int wrapWidth = Math.max(components.stream().map(c -> c instanceof ClientTextTooltip ? 0 : c.getWidth(EmiRenderHelper.CLIENT.font)).max(Integer::compare).orElse(0), maxWidth);
        for (ClientTooltipComponent comp : components) {
            ClientTextTooltip ottc;
            if (comp instanceof ClientTextTooltip && (ottc = (ClientTextTooltip)comp).getWidth(EmiRenderHelper.CLIENT.font) > wrapWidth) {
                try {
                    FormattedCharSequence ordered = ((OrderedTextTooltipComponentAccessor)ottc).getText();
                    MutableComponent text = Component.empty();
                    ordered.accept((var1, style, codepoint) -> {
                        text.append((Component)EmiPort.literal(String.valueOf(Character.toChars(codepoint)), style));
                        return true;
                    });
                    for (FormattedCharSequence o : EmiRenderHelper.CLIENT.font.split((FormattedText)text, wrapWidth)) {
                        mutable.add(ClientTooltipComponent.create((FormattedCharSequence)o));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mutable.add(comp);
                    continue;
                }
            }
            mutable.add(comp);
        }
        RenderSystem.enableDepthTest();
        EmiPort.setPositionTexShader();
        context.resetColor();
        ((DrawContextAccessor)context.raw()).invokeDrawTooltip(EmiRenderHelper.CLIENT.font, mutable, x, y, positioner);
    }

    public static void drawSlotHightlight(EmiDrawContext context, int x, int y, int w, int h, int z) {
        context.push();
        context.matrices().translate(0.0f, 0.0f, (float)z);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        context.fill(x, y, w, h, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        context.pop();
    }

    public static Component getAmountText(EmiIngredient stack) {
        return EmiRenderHelper.getAmountText(stack, stack.getAmount());
    }

    public static Component getAmountText(EmiIngredient stack, long amount) {
        if (stack.isEmpty() || amount == 0L) {
            return EMPTY_TEXT;
        }
        if (stack.getEmiStacks().get(0).getKey() instanceof Fluid) {
            return EmiRenderHelper.getFluidAmount(amount);
        }
        return EmiPort.literal("" + amount);
    }

    public static Component getAmountText(EmiIngredient stack, double amount) {
        if (stack.isEmpty() || amount == 0.0) {
            return EMPTY_TEXT;
        }
        if (stack.getEmiStacks().get(0).getKey() instanceof Fluid) {
            return EmiConfig.fluidUnit.translate(amount);
        }
        return EmiPort.literal(TEXT_FORMAT.format(amount));
    }

    public static Component getFluidAmount(long amount) {
        return EmiConfig.fluidUnit.translate(amount);
    }

    public static int getAmountOverflow(Component amount) {
        int width = EmiRenderHelper.CLIENT.font.width((FormattedText)amount);
        if (width > 14) {
            return width - 14;
        }
        return 0;
    }

    public static void renderAmount(EmiDrawContext context, int x, int y, Component amount) {
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        int tx = x + 17 - Math.min(14, EmiRenderHelper.CLIENT.font.width((FormattedText)amount));
        context.drawTextWithShadow(amount, tx, y + 9, -1);
        context.pop();
    }

    public static void renderIngredient(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        RenderSystem.enableDepthTest();
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
        context.drawTexture(WIDGETS, x, y, 8, 252, 4, 4);
        context.pop();
    }

    public static void renderTag(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        if (ingredient.getEmiStacks().size() > 1) {
            RenderSystem.enableDepthTest();
            context.push();
            context.matrices().translate(0.0f, 0.0f, 200.0f);
            context.drawTexture(WIDGETS, x, y + 12, 0, 252, 4, 4);
            context.pop();
        }
    }

    public static void renderRemainder(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        for (EmiStack stack : ingredient.getEmiStacks()) {
            EmiStack remainder = stack.getRemainder();
            if (remainder.isEmpty()) continue;
            if (remainder.equals(ingredient)) {
                EmiRenderHelper.renderCatalyst(ingredient, context, x, y);
            } else {
                context.push();
                context.matrices().translate(0.0f, 0.0f, 200.0f);
                RenderSystem.enableDepthTest();
                context.drawTexture(WIDGETS, x + 12, y, 4, 252, 4, 4);
                context.pop();
            }
            return;
        }
    }

    public static void renderCatalyst(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        RenderSystem.enableDepthTest();
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        context.drawTexture(WIDGETS, x + 12, y, 12, 252, 4, 4);
        context.pop();
    }

    public static void renderRecipeFavorite(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        RenderSystem.enableDepthTest();
        context.drawTexture(WIDGETS, x + 12, y, 16, 252, 4, 4);
        context.pop();
    }

    public static void renderRecipeBackground(EmiRecipe recipe, EmiDrawContext context, int x, int y) {
        context.resetColor();
        EmiRenderHelper.drawNinePatch(context, BACKGROUND, x, y, recipe.getDisplayWidth() + 8, recipe.getDisplayHeight() + 8, 27, 0, 4, 1);
    }

    public static void renderRecipe(final EmiRecipe recipe, EmiDrawContext context, int x, int y, boolean showMissing, int overlayColor) {
        try {
            EmiRenderHelper.renderRecipeBackground(recipe, context, x, y);
            final ArrayList widgets = Lists.newArrayList();
            WidgetHolder holder = new WidgetHolder(){

                @Override
                public int getWidth() {
                    return recipe.getDisplayWidth();
                }

                @Override
                public int getHeight() {
                    return recipe.getDisplayHeight();
                }

                @Override
                public <T extends Widget> T add(T widget) {
                    widgets.add(widget);
                    return widget;
                }
            };
            context.push();
            context.matrices().translate((float)(x + 4), (float)(y + 4), 0.0f);
            recipe.addWidgets(holder);
            float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            for (Widget widget : widgets) {
                widget.render(context.raw(), -1000, -1000, delta);
            }
            if (overlayColor != -1) {
                context.fill(-1, -1, recipe.getDisplayWidth() + 2, recipe.getDisplayHeight() + 2, overlayColor);
            }
            if (showMissing) {
                AbstractContainerScreen<?> hs = EmiApi.getHandledScreen();
                EmiRecipeHandler<?> handler = EmiRecipeFiller.getFirstValidHandler(recipe, hs);
                if (handler != null) {
                    handler.render(recipe, new EmiCraftContext(hs, handler.getInventory(hs), EmiCraftContext.Type.FILL_BUTTON), widgets, context.raw());
                } else if (EmiScreenManager.lastPlayerInventory != null) {
                    StandardRecipeHandler.renderMissing(recipe, EmiScreenManager.lastPlayerInventory, widgets, context.raw());
                }
            }
            context.pop();
            RenderSystem.disableBlend();
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            RenderSystem.disableDepthTest();
            EmiRenderHelper.renderRecipeBackground(recipe, context, x, y);
            RenderSystem.enableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

