/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.registry.EmiRecipes;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class EmiPort {
    private static final RandomSource RANDOM = RandomSource.create();

    public static MutableComponent literal(String s) {
        return Component.literal((String)s);
    }

    public static MutableComponent literal(String s, ChatFormatting formatting) {
        return Component.literal((String)s).withStyle(formatting);
    }

    public static MutableComponent literal(String s, ChatFormatting ... formatting) {
        return Component.literal((String)s).withStyle(formatting);
    }

    public static MutableComponent literal(String s, Style style) {
        return Component.literal((String)s).setStyle(style);
    }

    public static MutableComponent translatable(String s) {
        return Component.translatable((String)s);
    }

    public static MutableComponent translatable(String s, ChatFormatting formatting) {
        return Component.translatable((String)s).withStyle(formatting);
    }

    public static MutableComponent translatable(String s, Object ... objects) {
        return Component.translatable((String)s, (Object[])objects);
    }

    public static MutableComponent append(MutableComponent text, Component appended) {
        return text.append(appended);
    }

    public static FormattedCharSequence ordered(Component text) {
        return text.getVisualOrderText();
    }

    public static Collection<ResourceLocation> findResources(ResourceManager manager, String prefix, Predicate<String> pred) {
        return manager.listResources(prefix, i -> pred.test(i.toString())).keySet();
    }

    public static InputStream getInputStream(Resource resource) {
        try {
            return resource.open();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BannerPatternLayers addRandomBanner(BannerPatternLayers patterns, Random random) {
        Registry bannerRegistry = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BANNER_PATTERN);
        return new BannerPatternLayers.Builder().addAll(patterns).add((Holder)bannerRegistry.getHolder(random.nextInt(bannerRegistry.size())).get(), DyeColor.values()[random.nextInt(DyeColor.values().length)]).build();
    }

    public static boolean canTallFlowerDuplicate(TallFlowerBlock tallFlowerBlock) {
        try {
            return tallFlowerBlock.isValidBonemealTarget(null, null, null) && tallFlowerBlock.isBonemealSuccess(null, null, null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void upload(VertexBuffer vb, BufferBuilder bldr) {
        vb.bind();
        vb.upload(bldr.buildOrThrow());
    }

    public static void setShader(VertexBuffer buf, Matrix4f mat) {
        buf.bind();
        buf.drawWithShader(mat, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
    }

    public static List<BakedQuad> getQuads(BakedModel model) {
        return model.getQuads(null, null, RANDOM);
    }

    public static void draw(BufferBuilder bufferBuilder) {
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static int getGuiScale(Minecraft client) {
        return (int)client.getWindow().getGuiScale();
    }

    public static void setPositionTexShader() {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public static void setPositionColorTexShader() {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
    }

    public static Registry<Item> getItemRegistry() {
        return BuiltInRegistries.ITEM;
    }

    public static Registry<Block> getBlockRegistry() {
        return BuiltInRegistries.BLOCK;
    }

    public static Registry<Fluid> getFluidRegistry() {
        return BuiltInRegistries.FLUID;
    }

    public static Registry<Potion> getPotionRegistry() {
        return BuiltInRegistries.POTION;
    }

    public static Registry<Enchantment> getEnchantmentRegistry() {
        Minecraft client = Minecraft.getInstance();
        return client.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
    }

    public static Button newButton(int x, int y, int w, int h, Component name, Button.OnPress action) {
        return Button.builder((Component)name, (Button.OnPress)action).pos(x, y).size(w, h).build();
    }

    public static ItemStack getOutput(Recipe<?> recipe) {
        Minecraft client = Minecraft.getInstance();
        return recipe.getResultItem((HolderLookup.Provider)client.level.registryAccess());
    }

    public static void focus(EditBox widget, boolean focused) {
        Minecraft client = Minecraft.getInstance();
        if (client != null && client.screen != null) {
            GuiEventListener currentFocus = client.screen.getFocused();
            if (!focused && currentFocus == widget || focused && currentFocus != widget) {
                client.screen.setFocused(null);
            }
        }
        widget.setFocused(focused);
    }

    public static Stream<Item> getDisabledItems() {
        Minecraft client = Minecraft.getInstance();
        FeatureFlagSet fs = client.level.enabledFeatures();
        return EmiPort.getItemRegistry().stream().filter(i -> !i.isEnabled(fs));
    }

    public static ResourceLocation getId(Recipe<?> recipe) {
        return EmiRecipes.recipeIds.get(recipe);
    }

    @Nullable
    public static RecipeHolder<?> getRecipe(ResourceLocation id) {
        RecipeManager manager;
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && id != null && (manager = client.level.getRecipeManager()) != null) {
            return manager.byKey(id).orElse(null);
        }
        return null;
    }

    public static Comparison compareStrict() {
        return Comparison.compareComponents();
    }

    public static ItemStack setPotion(ItemStack stack, Potion potion) {
        stack.update(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY, (Object)EmiPort.getPotionRegistry().wrapAsHolder((Object)potion), PotionContents::withPotion);
        return stack;
    }

    public static DataComponentPatch emptyExtraData() {
        return DataComponentPatch.EMPTY;
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.parse((String)id);
    }

    public static ResourceLocation id(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }
}

