/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.renderer.normal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperGlowLayer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperPowerLayer;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public class CreeperRenderer<E extends BaseCreeper>
extends GeoEntityRenderer<E> {
    public CreeperRenderer(EntityRendererProvider.Context renderManager, GeoModel<E> modelProvider) {
        super(renderManager, modelProvider);
        this.addRenderLayer(new CreeperGlowLayer(this));
        this.addRenderLayer(new CreeperPowerLayer(this));
    }

    public void render(@NotNull E creeper, float entityYaw, float partialTicks, PoseStack stack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        float f = ((BaseCreeper)((Object)creeper)).getSwelling(partialTicks);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        stack.scale(f2, f3, f2);
        super.render(creeper, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull E entity) {
        return this.model.getTextureResource(entity);
    }

    public void reRender(BakedGeoModel model, PoseStack poseStack, MultiBufferSource bufferSource, E animatable, RenderType renderType, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        float f = ((BaseCreeper)((Object)animatable)).getSwelling(partialTick);
        f = (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
        super.reRender(model, poseStack, bufferSource, animatable, renderType, buffer, partialTick, packedLight, LivingEntityRenderer.getOverlayCoords(animatable, (float)f), color);
    }

    public RenderType getRenderType(E animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

