/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzPOI;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class SempiternalSanctumBehavior {
    private static final HashSet<UUID> PLAYERS_IN_SANCTUMS = new HashSet();

    public static void runStructureMessagesAndFatigue(ServerPlayer serverPlayer) {
        StructureManager structureManager = ((ServerLevel)serverPlayer.level()).structureManager();
        StructureStart detectedStructure = structureManager.getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.SEMPITERNAL_SANCTUMS);
        if (detectedStructure.isValid()) {
            MobEffectInstance effect;
            if (EssenceOfTheBees.hasEssence(serverPlayer)) {
                if (!PLAYERS_IN_SANCTUMS.contains(serverPlayer.getUUID())) {
                    BlockPos structureCenter = detectedStructure.getBoundingBox().getCenter().below(20);
                    PoiManager poiManager = serverPlayer.serverLevel().getPoiManager();
                    List poiInRange = poiManager.getInSquare(pointOfInterestType -> pointOfInterestType.value() == BzPOI.ESSENCE_BLOCK_POI.get(), structureCenter, 6, PoiManager.Occupancy.ANY).toList();
                    if (poiInRange.isEmpty()) {
                        return;
                    }
                    PLAYERS_IN_SANCTUMS.add(serverPlayer.getUUID());
                    if (serverPlayer.tickCount > 40) {
                        ResourceLocation resourceLocation = ((Registry)serverPlayer.level().registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)detectedStructure.getStructure());
                        if (resourceLocation == null) {
                            return;
                        }
                        ChatFormatting color = resourceLocation.getPath().contains("_red") ? ChatFormatting.RED : (resourceLocation.getPath().contains("_yellow") ? ChatFormatting.YELLOW : (resourceLocation.getPath().contains("_green") ? ChatFormatting.GREEN : (resourceLocation.getPath().contains("_blue") ? ChatFormatting.BLUE : (resourceLocation.getPath().contains("_purple") ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.WHITE))));
                        MutableComponent message = Component.translatable((String)("system.the_bumblezone." + resourceLocation.getPath())).withStyle(ChatFormatting.BOLD).withStyle(color);
                        serverPlayer.displayClientMessage((Component)message, true);
                    }
                }
                ((GenericTrigger)((Object)BzCriterias.SEMPITERNAL_SANCTUM_ENTER_WITH_BEE_ESSENCE_TRIGGER.get())).trigger(serverPlayer);
            } else if (!(serverPlayer.isCreative() || serverPlayer.isSpectator() || (effect = serverPlayer.getEffect(MobEffects.DIG_SLOWDOWN)) != null && effect.getAmplifier() > 2)) {
                MutableComponent message = Component.translatable((String)"system.the_bumblezone.no_essence").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                serverPlayer.displayClientMessage((Component)message, true);
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 800, 3, false, false, true));
            }
            if (serverPlayer.tickCount % 60 == 0) {
                MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.SEMPITERNAL_SANCTUM.get()).getLocation(), true);
            }
        } else if (serverPlayer.tickCount % 60 == 0 && PLAYERS_IN_SANCTUMS.contains(serverPlayer.getUUID())) {
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.SEMPITERNAL_SANCTUM.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RADIANCE_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.LIFE_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CALMING_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.KNOWING_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CONTINUITY_EVENT.get()).getLocation(), false);
            PLAYERS_IN_SANCTUMS.remove(serverPlayer.getUUID());
        }
    }
}

